/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.ReceiptRuleNamesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReorderReceiptRuleSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReorderReceiptRuleSetRequest> {
    private final String ruleSetName;
    private final List<String> ruleNames;

    private ReorderReceiptRuleSetRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleNames = builder.ruleNames;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public List<String> ruleNames() {
        return this.ruleNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleSetName() == null ? 0 : this.ruleSetName().hashCode());
        hashCode = 31 * hashCode + (this.ruleNames() == null ? 0 : this.ruleNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReorderReceiptRuleSetRequest)) {
            return false;
        }
        ReorderReceiptRuleSetRequest other = (ReorderReceiptRuleSetRequest)((Object)obj);
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.ruleNames() == null ^ this.ruleNames() == null) {
            return false;
        }
        return other.ruleNames() == null || other.ruleNames().equals(this.ruleNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.ruleNames() != null) {
            sb.append("RuleNames: ").append(this.ruleNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String ruleSetName;
        private List<String> ruleNames;

        private BuilderImpl() {
        }

        private BuilderImpl(ReorderReceiptRuleSetRequest model) {
            this.setRuleSetName(model.ruleSetName);
            this.setRuleNames(model.ruleNames);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final Collection<String> getRuleNames() {
            return this.ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = ReceiptRuleNamesListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String ... ruleNames) {
            this.ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = ReceiptRuleNamesListCopier.copy(ruleNames);
        }

        public ReorderReceiptRuleSetRequest build() {
            return new ReorderReceiptRuleSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReorderReceiptRuleSetRequest> {
        public Builder ruleSetName(String var1);

        public Builder ruleNames(Collection<String> var1);

        public Builder ruleNames(String ... var1);
    }
}

