/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.Content;

public class ContentUnmarshaller
implements Unmarshaller<Content, StaxUnmarshallerContext> {
    private static final ContentUnmarshaller INSTANCE = new ContentUnmarshaller();

    public Content unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Content.Builder content = Content.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Data", targetDepth)) {
                    content.data(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Charset", targetDepth)) continue;
                content.charset(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Content)content.build();
    }

    public static ContentUnmarshaller getInstance() {
        return INSTANCE;
    }
}

