/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutIdentityPolicyRequestMarshaller
implements Marshaller<Request<PutIdentityPolicyRequest>, PutIdentityPolicyRequest> {
    public Request<PutIdentityPolicyRequest> marshall(PutIdentityPolicyRequest putIdentityPolicyRequest) {
        if (putIdentityPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putIdentityPolicyRequest, "SESClient");
        request.addParameter("Action", "PutIdentityPolicy");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putIdentityPolicyRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)putIdentityPolicyRequest.identity()));
        }
        if (putIdentityPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putIdentityPolicyRequest.policyName()));
        }
        if (putIdentityPolicyRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)putIdentityPolicyRequest.policy()));
        }
        return request;
    }
}

