/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete a configuration set. Configuration sets enable you to publish email sending events.
 * For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteConfigurationSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteConfigurationSetRequest.Builder, DeleteConfigurationSetRequest> {
    private final String configurationSetName;

    private DeleteConfigurationSetRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
    }

    /**
     * <p>
     * The name of the configuration set to delete.
     * </p>
     * 
     * @return The name of the configuration set to delete.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSetName() == null) ? 0 : configurationSetName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationSetRequest)) {
            return false;
        }
        DeleteConfigurationSetRequest other = (DeleteConfigurationSetRequest) obj;
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        if (other.configurationSetName() != null && !other.configurationSetName().equals(this.configurationSetName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(configurationSetName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteConfigurationSetRequest> {
        /**
         * <p>
         * The name of the configuration set to delete.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);
    }

    private static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationSetRequest model) {
            setConfigurationSetName(model.configurationSetName);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public DeleteConfigurationSetRequest build() {
            return new DeleteConfigurationSetRequest(this);
        }
    }
}
