/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return the details of a configuration set. Configuration sets enable you to publish email
 * sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeConfigurationSetRequest.Builder, DescribeConfigurationSetRequest> {
    private final String configurationSetName;

    private final List<String> configurationSetAttributeNames;

    private DescribeConfigurationSetRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
        this.configurationSetAttributeNames = builder.configurationSetAttributeNames;
    }

    /**
     * <p>
     * The name of the configuration set to describe.
     * </p>
     * 
     * @return The name of the configuration set to describe.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * A list of configuration set attributes to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of configuration set attributes to return.
     * @see ConfigurationSetAttribute
     */
    public List<String> configurationSetAttributeNames() {
        return configurationSetAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSetName() == null) ? 0 : configurationSetName().hashCode());
        hashCode = 31 * hashCode + ((configurationSetAttributeNames() == null) ? 0 : configurationSetAttributeNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetRequest)) {
            return false;
        }
        DescribeConfigurationSetRequest other = (DescribeConfigurationSetRequest) obj;
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        if (other.configurationSetName() != null && !other.configurationSetName().equals(this.configurationSetName())) {
            return false;
        }
        if (other.configurationSetAttributeNames() == null ^ this.configurationSetAttributeNames() == null) {
            return false;
        }
        if (other.configurationSetAttributeNames() != null
                && !other.configurationSetAttributeNames().equals(this.configurationSetAttributeNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(configurationSetName()).append(",");
        }
        if (configurationSetAttributeNames() != null) {
            sb.append("ConfigurationSetAttributeNames: ").append(configurationSetAttributeNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationSetRequest> {
        /**
         * <p>
         * The name of the configuration set to describe.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * A list of configuration set attributes to return.
         * </p>
         * 
         * @param configurationSetAttributeNames
         *        A list of configuration set attributes to return.
         * @see ConfigurationSetAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSetAttribute
         */
        Builder configurationSetAttributeNames(Collection<String> configurationSetAttributeNames);

        /**
         * <p>
         * A list of configuration set attributes to return.
         * </p>
         * 
         * @param configurationSetAttributeNames
         *        A list of configuration set attributes to return.
         * @see ConfigurationSetAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSetAttribute
         */
        Builder configurationSetAttributeNames(String... configurationSetAttributeNames);

        /**
         * <p>
         * A list of configuration set attributes to return.
         * </p>
         * 
         * @param configurationSetAttributeNames
         *        A list of configuration set attributes to return.
         * @see ConfigurationSetAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationSetAttribute
         */
        Builder configurationSetAttributeNames(ConfigurationSetAttribute... configurationSetAttributeNames);
    }

    private static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private List<String> configurationSetAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetRequest model) {
            setConfigurationSetName(model.configurationSetName);
            setConfigurationSetAttributeNames(model.configurationSetAttributeNames);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<String> getConfigurationSetAttributeNames() {
            return configurationSetAttributeNames;
        }

        @Override
        public final Builder configurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(String... configurationSetAttributeNames) {
            configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(ConfigurationSetAttribute... configurationSetAttributeNames) {
            configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames).stream().map(Object::toString)
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
        }

        @Override
        public DescribeConfigurationSetRequest build() {
            return new DescribeConfigurationSetRequest(this);
        }
    }
}
