/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityMailFromDomainAttributesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIdentityMailFromDomainAttributesResponse.Builder, GetIdentityMailFromDomainAttributesResponse> {
    private final Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

    private GetIdentityMailFromDomainAttributesResponse(BuilderImpl builder) {
        this.mailFromDomainAttributes = builder.mailFromDomainAttributes;
    }

    /**
     * <p>
     * A map of identities to custom MAIL FROM attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of identities to custom MAIL FROM attributes.
     */
    public Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes() {
        return mailFromDomainAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mailFromDomainAttributes() == null) ? 0 : mailFromDomainAttributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityMailFromDomainAttributesResponse)) {
            return false;
        }
        GetIdentityMailFromDomainAttributesResponse other = (GetIdentityMailFromDomainAttributesResponse) obj;
        if (other.mailFromDomainAttributes() == null ^ this.mailFromDomainAttributes() == null) {
            return false;
        }
        if (other.mailFromDomainAttributes() != null && !other.mailFromDomainAttributes().equals(this.mailFromDomainAttributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mailFromDomainAttributes() != null) {
            sb.append("MailFromDomainAttributes: ").append(mailFromDomainAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityMailFromDomainAttributesResponse> {
        /**
         * <p>
         * A map of identities to custom MAIL FROM attributes.
         * </p>
         * 
         * @param mailFromDomainAttributes
         *        A map of identities to custom MAIL FROM attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityMailFromDomainAttributesResponse model) {
            setMailFromDomainAttributes(model.mailFromDomainAttributes);
        }

        public final Map<String, IdentityMailFromDomainAttributes> getMailFromDomainAttributes() {
            return mailFromDomainAttributes;
        }

        @Override
        public final Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copy(mailFromDomainAttributes);
            return this;
        }

        public final void setMailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copy(mailFromDomainAttributes);
        }

        @Override
        public GetIdentityMailFromDomainAttributesResponse build() {
            return new GetIdentityMailFromDomainAttributesResponse(this);
        }
    }
}
