/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon SES verification status of a list of identities. For domain identities, this response also contains the
 * verification token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityVerificationAttributesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIdentityVerificationAttributesResponse.Builder, GetIdentityVerificationAttributesResponse> {
    private final Map<String, IdentityVerificationAttributes> verificationAttributes;

    private GetIdentityVerificationAttributesResponse(BuilderImpl builder) {
        this.verificationAttributes = builder.verificationAttributes;
    }

    /**
     * <p>
     * A map of Identities to IdentityVerificationAttributes objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of Identities to IdentityVerificationAttributes objects.
     */
    public Map<String, IdentityVerificationAttributes> verificationAttributes() {
        return verificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((verificationAttributes() == null) ? 0 : verificationAttributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesResponse)) {
            return false;
        }
        GetIdentityVerificationAttributesResponse other = (GetIdentityVerificationAttributesResponse) obj;
        if (other.verificationAttributes() == null ^ this.verificationAttributes() == null) {
            return false;
        }
        if (other.verificationAttributes() != null && !other.verificationAttributes().equals(this.verificationAttributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (verificationAttributes() != null) {
            sb.append("VerificationAttributes: ").append(verificationAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
        /**
         * <p>
         * A map of Identities to IdentityVerificationAttributes objects.
         * </p>
         * 
         * @param verificationAttributes
         *        A map of Identities to IdentityVerificationAttributes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, IdentityVerificationAttributes> verificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesResponse model) {
            setVerificationAttributes(model.verificationAttributes);
        }

        public final Map<String, IdentityVerificationAttributes> getVerificationAttributes() {
            return verificationAttributes;
        }

        @Override
        public final Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copy(verificationAttributes);
            return this;
        }

        public final void setVerificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copy(verificationAttributes);
        }

        @Override
        public GetIdentityVerificationAttributesResponse build() {
            return new GetIdentityVerificationAttributesResponse(this);
        }
    }
}
