/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a list of data points. This list contains aggregated data from the previous two weeks of your sending
 * activity with Amazon SES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSendStatisticsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetSendStatisticsResponse.Builder, GetSendStatisticsResponse> {
    private final List<SendDataPoint> sendDataPoints;

    private GetSendStatisticsResponse(BuilderImpl builder) {
        this.sendDataPoints = builder.sendDataPoints;
    }

    /**
     * <p>
     * A list of data points, each of which represents 15 minutes of activity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of data points, each of which represents 15 minutes of activity.
     */
    public List<SendDataPoint> sendDataPoints() {
        return sendDataPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sendDataPoints() == null) ? 0 : sendDataPoints().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendStatisticsResponse)) {
            return false;
        }
        GetSendStatisticsResponse other = (GetSendStatisticsResponse) obj;
        if (other.sendDataPoints() == null ^ this.sendDataPoints() == null) {
            return false;
        }
        if (other.sendDataPoints() != null && !other.sendDataPoints().equals(this.sendDataPoints())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sendDataPoints() != null) {
            sb.append("SendDataPoints: ").append(sendDataPoints()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSendStatisticsResponse> {
        /**
         * <p>
         * A list of data points, each of which represents 15 minutes of activity.
         * </p>
         * 
         * @param sendDataPoints
         *        A list of data points, each of which represents 15 minutes of activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendDataPoints(Collection<SendDataPoint> sendDataPoints);

        /**
         * <p>
         * A list of data points, each of which represents 15 minutes of activity.
         * </p>
         * 
         * @param sendDataPoints
         *        A list of data points, each of which represents 15 minutes of activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendDataPoints(SendDataPoint... sendDataPoints);
    }

    private static final class BuilderImpl implements Builder {
        private List<SendDataPoint> sendDataPoints;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendStatisticsResponse model) {
            setSendDataPoints(model.sendDataPoints);
        }

        public final Collection<SendDataPoint> getSendDataPoints() {
            return sendDataPoints;
        }

        @Override
        public final Builder sendDataPoints(Collection<SendDataPoint> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copy(sendDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(SendDataPoint... sendDataPoints) {
            sendDataPoints(Arrays.asList(sendDataPoints));
            return this;
        }

        public final void setSendDataPoints(Collection<SendDataPoint> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copy(sendDataPoints);
        }

        @Override
        public GetSendStatisticsResponse build() {
            return new GetSendStatisticsResponse(this);
        }
    }
}
