/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return a list of all identities (email addresses and domains) that you have attempted to
 * verify under your AWS account, regardless of verification status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentitiesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListIdentitiesRequest.Builder, ListIdentitiesRequest> {
    private final String identityType;

    private final String nextToken;

    private final Integer maxItems;

    private ListIdentitiesRequest(BuilderImpl builder) {
        this.identityType = builder.identityType;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is
     * omitted, then all identities will be listed.
     * </p>
     * 
     * @return The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is
     *         omitted, then all identities will be listed.
     * @see IdentityType
     */
    public String identityType() {
        return identityType;
    }

    /**
     * <p>
     * The token to use for pagination.
     * </p>
     * 
     * @return The token to use for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of identities per page. Possible values are 1-1000 inclusive.
     * </p>
     * 
     * @return The maximum number of identities per page. Possible values are 1-1000 inclusive.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identityType() == null) ? 0 : identityType().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesRequest)) {
            return false;
        }
        ListIdentitiesRequest other = (ListIdentitiesRequest) obj;
        if (other.identityType() == null ^ this.identityType() == null) {
            return false;
        }
        if (other.identityType() != null && !other.identityType().equals(this.identityType())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identityType() != null) {
            sb.append("IdentityType: ").append(identityType()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListIdentitiesRequest> {
        /**
         * <p>
         * The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is
         * omitted, then all identities will be listed.
         * </p>
         * 
         * @param identityType
         *        The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter
         *        is omitted, then all identities will be listed.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is
         * omitted, then all identities will be listed.
         * </p>
         * 
         * @param identityType
         *        The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter
         *        is omitted, then all identities will be listed.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The token to use for pagination.
         * </p>
         * 
         * @param nextToken
         *        The token to use for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of identities per page. Possible values are 1-1000 inclusive.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of identities per page. Possible values are 1-1000 inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private String identityType;

        private String nextToken;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesRequest model) {
            setIdentityType(model.identityType);
            setNextToken(model.nextToken);
            setMaxItems(model.maxItems);
        }

        public final String getIdentityType() {
            return identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListIdentitiesRequest build() {
            return new ListIdentitiesRequest(this);
        }
    }
}
