/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of all identities that you have attempted to verify under your AWS account, regardless of verification status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentitiesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListIdentitiesResponse.Builder, ListIdentitiesResponse> {
    private final List<String> identities;

    private final String nextToken;

    private ListIdentitiesResponse(BuilderImpl builder) {
        this.identities = builder.identities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of identities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of identities.
     */
    public List<String> identities() {
        return identities;
    }

    /**
     * <p>
     * The token used for pagination.
     * </p>
     * 
     * @return The token used for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identities() == null) ? 0 : identities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResponse)) {
            return false;
        }
        ListIdentitiesResponse other = (ListIdentitiesResponse) obj;
        if (other.identities() == null ^ this.identities() == null) {
            return false;
        }
        if (other.identities() != null && !other.identities().equals(this.identities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identities() != null) {
            sb.append("Identities: ").append(identities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListIdentitiesResponse> {
        /**
         * <p>
         * A list of identities.
         * </p>
         * 
         * @param identities
         *        A list of identities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Collection<String> identities);

        /**
         * <p>
         * A list of identities.
         * </p>
         * 
         * @param identities
         *        A list of identities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(String... identities);

        /**
         * <p>
         * The token used for pagination.
         * </p>
         * 
         * @param nextToken
         *        The token used for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> identities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesResponse model) {
            setIdentities(model.identities);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getIdentities() {
            return identities;
        }

        @Override
        public final Builder identities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(String... identities) {
            identities(Arrays.asList(identities));
            return this;
        }

        public final void setIdentities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentitiesResponse build() {
            return new ListIdentitiesResponse(this);
        }
    }
}
