/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recipient-related information to include in the Delivery Status Notification (DSN) when an email that Amazon SES
 * receives on your behalf bounces.
 * </p>
 * <p>
 * For information about receiving email through Amazon SES, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecipientDsnFields implements ToCopyableBuilder<RecipientDsnFields.Builder, RecipientDsnFields> {
    private final String finalRecipient;

    private final String action;

    private final String remoteMta;

    private final String status;

    private final String diagnosticCode;

    private final Instant lastAttemptDate;

    private final List<ExtensionField> extensionFields;

    private RecipientDsnFields(BuilderImpl builder) {
        this.finalRecipient = builder.finalRecipient;
        this.action = builder.action;
        this.remoteMta = builder.remoteMta;
        this.status = builder.status;
        this.diagnosticCode = builder.diagnosticCode;
        this.lastAttemptDate = builder.lastAttemptDate;
        this.extensionFields = builder.extensionFields;
    }

    /**
     * <p>
     * The email address to which the message was ultimately delivered. This corresponds to the
     * <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> will be set to the
     * <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
     * <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the
     * original bounced message.
     * </p>
     * <note>
     * <p>
     * Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in <a
     * href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
     * </p>
     * </note>
     * 
     * @return The email address to which the message was ultimately delivered. This corresponds to the
     *         <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> will be set to the
     *         <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
     *         <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of
     *         the original bounced message.</p> <note>
     *         <p>
     *         Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in
     *         <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
     *         </p>
     */
    public String finalRecipient() {
        return finalRecipient;
    }

    /**
     * <p>
     * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the message
     * to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     * </p>
     * 
     * @return The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
     *         message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
     *         3464</a>.
     * @see DsnAction
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
     * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This parameter
     * typically applies only to propagating synchronous bounces.
     * </p>
     * 
     * @return The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
     *         href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This
     *         parameter typically applies only to propagating synchronous bounces.
     */
    public String remoteMta() {
        return remoteMta;
    }

    /**
     * <p>
     * The status code that indicates what went wrong. This is required by <a
     * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     * </p>
     * 
     * @return The status code that indicates what went wrong. This is required by <a
     *         href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * An extended explanation of what went wrong; this is usually an SMTP response. See <a
     * href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
     * </p>
     * 
     * @return An extended explanation of what went wrong; this is usually an SMTP response. See <a
     *         href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
     */
    public String diagnosticCode() {
        return diagnosticCode;
    }

    /**
     * <p>
     * The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>
     * date-time format.
     * </p>
     * 
     * @return The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC
     *         822</a> date-time format.
     */
    public Instant lastAttemptDate() {
        return lastAttemptDate;
    }

    /**
     * <p>
     * Additional X-headers to include in the DSN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional X-headers to include in the DSN.
     */
    public List<ExtensionField> extensionFields() {
        return extensionFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((finalRecipient() == null) ? 0 : finalRecipient().hashCode());
        hashCode = 31 * hashCode + ((action() == null) ? 0 : action().hashCode());
        hashCode = 31 * hashCode + ((remoteMta() == null) ? 0 : remoteMta().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((diagnosticCode() == null) ? 0 : diagnosticCode().hashCode());
        hashCode = 31 * hashCode + ((lastAttemptDate() == null) ? 0 : lastAttemptDate().hashCode());
        hashCode = 31 * hashCode + ((extensionFields() == null) ? 0 : extensionFields().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientDsnFields)) {
            return false;
        }
        RecipientDsnFields other = (RecipientDsnFields) obj;
        if (other.finalRecipient() == null ^ this.finalRecipient() == null) {
            return false;
        }
        if (other.finalRecipient() != null && !other.finalRecipient().equals(this.finalRecipient())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.remoteMta() == null ^ this.remoteMta() == null) {
            return false;
        }
        if (other.remoteMta() != null && !other.remoteMta().equals(this.remoteMta())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.diagnosticCode() == null ^ this.diagnosticCode() == null) {
            return false;
        }
        if (other.diagnosticCode() != null && !other.diagnosticCode().equals(this.diagnosticCode())) {
            return false;
        }
        if (other.lastAttemptDate() == null ^ this.lastAttemptDate() == null) {
            return false;
        }
        if (other.lastAttemptDate() != null && !other.lastAttemptDate().equals(this.lastAttemptDate())) {
            return false;
        }
        if (other.extensionFields() == null ^ this.extensionFields() == null) {
            return false;
        }
        if (other.extensionFields() != null && !other.extensionFields().equals(this.extensionFields())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (finalRecipient() != null) {
            sb.append("FinalRecipient: ").append(finalRecipient()).append(",");
        }
        if (action() != null) {
            sb.append("Action: ").append(action()).append(",");
        }
        if (remoteMta() != null) {
            sb.append("RemoteMta: ").append(remoteMta()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (diagnosticCode() != null) {
            sb.append("DiagnosticCode: ").append(diagnosticCode()).append(",");
        }
        if (lastAttemptDate() != null) {
            sb.append("LastAttemptDate: ").append(lastAttemptDate()).append(",");
        }
        if (extensionFields() != null) {
            sb.append("ExtensionFields: ").append(extensionFields()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RecipientDsnFields> {
        /**
         * <p>
         * The email address to which the message was ultimately delivered. This corresponds to the
         * <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> will be set to the
         * <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
         * <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient of the
         * original bounced message.
         * </p>
         * <note>
         * <p>
         * Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described in <a
         * href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
         * </p>
         * </note>
         * 
         * @param finalRecipient
         *        The email address to which the message was ultimately delivered. This corresponds to the
         *        <code>Final-Recipient</code> in the DSN. If not specified, <code>FinalRecipient</code> will be set to
         *        the <code>Recipient</code> specified in the <code>BouncedRecipientInfo</code> structure. Either
         *        <code>FinalRecipient</code> or the recipient in <code>BouncedRecipientInfo</code> must be a recipient
         *        of the original bounced message.</p> <note>
         *        <p>
         *        Do not prepend the <code>FinalRecipient</code> email address with <code>rfc 822;</code>, as described
         *        in <a href="https://tools.ietf.org/html/rfc3798">RFC 3798</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalRecipient(String finalRecipient);

        /**
         * <p>
         * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
         * message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
         * 3464</a>.
         * </p>
         * 
         * @param action
         *        The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver
         *        the message to the recipient address. This is required by <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * @see DsnAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DsnAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver the
         * message to the recipient address. This is required by <a href="https://tools.ietf.org/html/rfc3464">RFC
         * 3464</a>.
         * </p>
         * 
         * @param action
         *        The action performed by the reporting mail transfer agent (MTA) as a result of its attempt to deliver
         *        the message to the recipient address. This is required by <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * @see DsnAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DsnAction
         */
        Builder action(DsnAction action);

        /**
         * <p>
         * The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
         * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This
         * parameter typically applies only to propagating synchronous bounces.
         * </p>
         * 
         * @param remoteMta
         *        The MTA to which the remote MTA attempted to deliver the message, formatted as specified in <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a> (<code>mta-name-type; mta-name</code>). This
         *        parameter typically applies only to propagating synchronous bounces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteMta(String remoteMta);

        /**
         * <p>
         * The status code that indicates what went wrong. This is required by <a
         * href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * </p>
         * 
         * @param status
         *        The status code that indicates what went wrong. This is required by <a
         *        href="https://tools.ietf.org/html/rfc3464">RFC 3464</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * An extended explanation of what went wrong; this is usually an SMTP response. See <a
         * href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
         * </p>
         * 
         * @param diagnosticCode
         *        An extended explanation of what went wrong; this is usually an SMTP response. See <a
         *        href="https://tools.ietf.org/html/rfc3463">RFC 3463</a> for the correct formatting of this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnosticCode(String diagnosticCode);

        /**
         * <p>
         * The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC 822</a>
         * date-time format.
         * </p>
         * 
         * @param lastAttemptDate
         *        The time the final delivery attempt was made, in <a href="https://www.ietf.org/rfc/rfc0822.txt">RFC
         *        822</a> date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptDate(Instant lastAttemptDate);

        /**
         * <p>
         * Additional X-headers to include in the DSN.
         * </p>
         * 
         * @param extensionFields
         *        Additional X-headers to include in the DSN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionFields(Collection<ExtensionField> extensionFields);

        /**
         * <p>
         * Additional X-headers to include in the DSN.
         * </p>
         * 
         * @param extensionFields
         *        Additional X-headers to include in the DSN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionFields(ExtensionField... extensionFields);
    }

    private static final class BuilderImpl implements Builder {
        private String finalRecipient;

        private String action;

        private String remoteMta;

        private String status;

        private String diagnosticCode;

        private Instant lastAttemptDate;

        private List<ExtensionField> extensionFields;

        private BuilderImpl() {
        }

        private BuilderImpl(RecipientDsnFields model) {
            setFinalRecipient(model.finalRecipient);
            setAction(model.action);
            setRemoteMta(model.remoteMta);
            setStatus(model.status);
            setDiagnosticCode(model.diagnosticCode);
            setLastAttemptDate(model.lastAttemptDate);
            setExtensionFields(model.extensionFields);
        }

        public final String getFinalRecipient() {
            return finalRecipient;
        }

        @Override
        public final Builder finalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
            return this;
        }

        public final void setFinalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DsnAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRemoteMta() {
            return remoteMta;
        }

        @Override
        public final Builder remoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
            return this;
        }

        public final void setRemoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDiagnosticCode() {
            return diagnosticCode;
        }

        @Override
        public final Builder diagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
            return this;
        }

        public final void setDiagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
        }

        public final Instant getLastAttemptDate() {
            return lastAttemptDate;
        }

        @Override
        public final Builder lastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
            return this;
        }

        public final void setLastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
        }

        public final Collection<ExtensionField> getExtensionFields() {
            return extensionFields;
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField... extensionFields) {
            extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        public final void setExtensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
        }

        @Override
        public RecipientDsnFields build() {
            return new RecipientDsnFields(this);
        }
    }
}
