/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents sending statistics data. Each <code>SendDataPoint</code> contains statistics for a 15-minute period of
 * sending activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SendDataPoint implements ToCopyableBuilder<SendDataPoint.Builder, SendDataPoint> {
    private final Instant timestamp;

    private final Long deliveryAttempts;

    private final Long bounces;

    private final Long complaints;

    private final Long rejects;

    private SendDataPoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.deliveryAttempts = builder.deliveryAttempts;
        this.bounces = builder.bounces;
        this.complaints = builder.complaints;
        this.rejects = builder.rejects;
    }

    /**
     * <p>
     * Time of the data point.
     * </p>
     * 
     * @return Time of the data point.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Number of emails that have been sent.
     * </p>
     * 
     * @return Number of emails that have been sent.
     */
    public Long deliveryAttempts() {
        return deliveryAttempts;
    }

    /**
     * <p>
     * Number of emails that have bounced.
     * </p>
     * 
     * @return Number of emails that have bounced.
     */
    public Long bounces() {
        return bounces;
    }

    /**
     * <p>
     * Number of unwanted emails that were rejected by recipients.
     * </p>
     * 
     * @return Number of unwanted emails that were rejected by recipients.
     */
    public Long complaints() {
        return complaints;
    }

    /**
     * <p>
     * Number of emails rejected by Amazon SES.
     * </p>
     * 
     * @return Number of emails rejected by Amazon SES.
     */
    public Long rejects() {
        return rejects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((deliveryAttempts() == null) ? 0 : deliveryAttempts().hashCode());
        hashCode = 31 * hashCode + ((bounces() == null) ? 0 : bounces().hashCode());
        hashCode = 31 * hashCode + ((complaints() == null) ? 0 : complaints().hashCode());
        hashCode = 31 * hashCode + ((rejects() == null) ? 0 : rejects().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataPoint)) {
            return false;
        }
        SendDataPoint other = (SendDataPoint) obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.deliveryAttempts() == null ^ this.deliveryAttempts() == null) {
            return false;
        }
        if (other.deliveryAttempts() != null && !other.deliveryAttempts().equals(this.deliveryAttempts())) {
            return false;
        }
        if (other.bounces() == null ^ this.bounces() == null) {
            return false;
        }
        if (other.bounces() != null && !other.bounces().equals(this.bounces())) {
            return false;
        }
        if (other.complaints() == null ^ this.complaints() == null) {
            return false;
        }
        if (other.complaints() != null && !other.complaints().equals(this.complaints())) {
            return false;
        }
        if (other.rejects() == null ^ this.rejects() == null) {
            return false;
        }
        if (other.rejects() != null && !other.rejects().equals(this.rejects())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (deliveryAttempts() != null) {
            sb.append("DeliveryAttempts: ").append(deliveryAttempts()).append(",");
        }
        if (bounces() != null) {
            sb.append("Bounces: ").append(bounces()).append(",");
        }
        if (complaints() != null) {
            sb.append("Complaints: ").append(complaints()).append(",");
        }
        if (rejects() != null) {
            sb.append("Rejects: ").append(rejects()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SendDataPoint> {
        /**
         * <p>
         * Time of the data point.
         * </p>
         * 
         * @param timestamp
         *        Time of the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Number of emails that have been sent.
         * </p>
         * 
         * @param deliveryAttempts
         *        Number of emails that have been sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryAttempts(Long deliveryAttempts);

        /**
         * <p>
         * Number of emails that have bounced.
         * </p>
         * 
         * @param bounces
         *        Number of emails that have bounced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounces(Long bounces);

        /**
         * <p>
         * Number of unwanted emails that were rejected by recipients.
         * </p>
         * 
         * @param complaints
         *        Number of unwanted emails that were rejected by recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaints(Long complaints);

        /**
         * <p>
         * Number of emails rejected by Amazon SES.
         * </p>
         * 
         * @param rejects
         *        Number of emails rejected by Amazon SES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejects(Long rejects);
    }

    private static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private Long deliveryAttempts;

        private Long bounces;

        private Long complaints;

        private Long rejects;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataPoint model) {
            setTimestamp(model.timestamp);
            setDeliveryAttempts(model.deliveryAttempts);
            setBounces(model.bounces);
            setComplaints(model.complaints);
            setRejects(model.rejects);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Long getDeliveryAttempts() {
            return deliveryAttempts;
        }

        @Override
        public final Builder deliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
            return this;
        }

        public final void setDeliveryAttempts(Long deliveryAttempts) {
            this.deliveryAttempts = deliveryAttempts;
        }

        public final Long getBounces() {
            return bounces;
        }

        @Override
        public final Builder bounces(Long bounces) {
            this.bounces = bounces;
            return this;
        }

        public final void setBounces(Long bounces) {
            this.bounces = bounces;
        }

        public final Long getComplaints() {
            return complaints;
        }

        @Override
        public final Builder complaints(Long complaints) {
            this.complaints = complaints;
            return this;
        }

        public final void setComplaints(Long complaints) {
            this.complaints = complaints;
        }

        public final Long getRejects() {
            return rejects;
        }

        @Override
        public final Builder rejects(Long rejects) {
            this.rejects = rejects;
            return this;
        }

        public final void setRejects(Long rejects) {
            this.rejects = rejects;
        }

        @Override
        public SendDataPoint build() {
            return new SendDataPoint(this);
        }
    }
}
