/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetIdentityVerificationAttributesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityVerificationAttributesResponseUnmarshaller implements
        Unmarshaller<GetIdentityVerificationAttributesResponse, StaxUnmarshallerContext> {

    private static class VerificationAttributesMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, IdentityVerificationAttributes>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, IdentityVerificationAttributes> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, IdentityVerificationAttributes> entry = new MapEntry<String, IdentityVerificationAttributes>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(IdentityVerificationAttributesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final VerificationAttributesMapEntryUnmarshaller INSTANCE = new VerificationAttributesMapEntryUnmarshaller();

        public static VerificationAttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public GetIdentityVerificationAttributesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetIdentityVerificationAttributesResponse.Builder getIdentityVerificationAttributesResponse = GetIdentityVerificationAttributesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.Map<String, IdentityVerificationAttributes> verificationAttributes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                getIdentityVerificationAttributesResponse.verificationAttributes(verificationAttributes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("VerificationAttributes/entry", targetDepth)) {
                    if (verificationAttributes == null) {
                        verificationAttributes = new java.util.HashMap<>();
                    }
                    Entry<String, IdentityVerificationAttributes> entry = VerificationAttributesMapEntryUnmarshaller
                            .getInstance().unmarshall(context);
                    // getIdentityVerificationAttributesResponse.addVerificationAttributesEntry(entry.getKey(),
                    // entry.getValue());

                    verificationAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    getIdentityVerificationAttributesResponse.verificationAttributes(verificationAttributes);
                    break;
                }
            }
        }
        return getIdentityVerificationAttributesResponse.build();
    }

    private static final GetIdentityVerificationAttributesResponseUnmarshaller INSTANCE = new GetIdentityVerificationAttributesResponseUnmarshaller();

    public static GetIdentityVerificationAttributesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
