/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * UpdateConfigurationSetEventDestinationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateConfigurationSetEventDestinationRequestMarshaller implements
        Marshaller<Request<UpdateConfigurationSetEventDestinationRequest>, UpdateConfigurationSetEventDestinationRequest> {

    public Request<UpdateConfigurationSetEventDestinationRequest> marshall(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {

        if (updateConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UpdateConfigurationSetEventDestinationRequest> request = new DefaultRequest<UpdateConfigurationSetEventDestinationRequest>(
                updateConfigurationSetEventDestinationRequest, "SESClient");
        request.addParameter("Action", "UpdateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateConfigurationSetEventDestinationRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringUtils.fromString(updateConfigurationSetEventDestinationRequest.configurationSetName()));
        }

        EventDestination eventDestination = updateConfigurationSetEventDestinationRequest.eventDestination();
        if (eventDestination != null) {

            if (eventDestination.name() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString(eventDestination.name()));
            }

            if (eventDestination.enabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean(eventDestination.enabled()));
            }

            java.util.List<String> matchingEventTypesList = eventDestination.matchingEventTypes();

            if (matchingEventTypesList != null) {
                if (!matchingEventTypesList.isEmpty()) {
                    int matchingEventTypesListIndex = 1;

                    for (String matchingEventTypesListValue : matchingEventTypesList) {
                        if (matchingEventTypesListValue != null) {
                            request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex,
                                    StringUtils.fromString(matchingEventTypesListValue));
                        }
                        matchingEventTypesListIndex++;
                    }
                } else {
                    request.addParameter("EventDestination.MatchingEventTypes", "");
                }
            }

            KinesisFirehoseDestination kinesisFirehoseDestination = eventDestination.kinesisFirehoseDestination();
            if (kinesisFirehoseDestination != null) {

                if (kinesisFirehoseDestination.iamRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN",
                            StringUtils.fromString(kinesisFirehoseDestination.iamRoleARN()));
                }

                if (kinesisFirehoseDestination.deliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN",
                            StringUtils.fromString(kinesisFirehoseDestination.deliveryStreamARN()));
                }
            }

            CloudWatchDestination cloudWatchDestination = eventDestination.cloudWatchDestination();
            if (cloudWatchDestination != null) {

                java.util.List<CloudWatchDimensionConfiguration> dimensionConfigurationsList = cloudWatchDestination
                        .dimensionConfigurations();

                if (dimensionConfigurationsList != null) {
                    if (!dimensionConfigurationsList.isEmpty()) {
                        int dimensionConfigurationsListIndex = 1;

                        for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {

                            if (dimensionConfigurationsListValue.dimensionName() != null) {
                                request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                        + dimensionConfigurationsListIndex + ".DimensionName",
                                        StringUtils.fromString(dimensionConfigurationsListValue.dimensionName()));
                            }

                            if (dimensionConfigurationsListValue.dimensionValueSource() != null) {
                                request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                        + dimensionConfigurationsListIndex + ".DimensionValueSource",
                                        StringUtils.fromString(dimensionConfigurationsListValue.dimensionValueSource()));
                            }

                            if (dimensionConfigurationsListValue.defaultDimensionValue() != null) {
                                request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                        + dimensionConfigurationsListIndex + ".DefaultDimensionValue",
                                        StringUtils.fromString(dimensionConfigurationsListValue.defaultDimensionValue()));
                            }
                            dimensionConfigurationsListIndex++;
                        }
                    } else {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations", "");
                    }
                }
            }
        }

        return request;
    }

}
