/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * VerifyDomainDkimRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VerifyDomainDkimRequestMarshaller implements Marshaller<Request<VerifyDomainDkimRequest>, VerifyDomainDkimRequest> {

    public Request<VerifyDomainDkimRequest> marshall(VerifyDomainDkimRequest verifyDomainDkimRequest) {

        if (verifyDomainDkimRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<VerifyDomainDkimRequest> request = new DefaultRequest<VerifyDomainDkimRequest>(verifyDomainDkimRequest,
                "SESClient");
        request.addParameter("Action", "VerifyDomainDkim");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (verifyDomainDkimRequest.domain() != null) {
            request.addParameter("Domain", StringUtils.fromString(verifyDomainDkimRequest.domain()));
        }

        return request;
    }

}
