/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum EventType {
    Send("send"),
    Reject("reject"),
    Bounce("bounce"),
    Complaint("complaint"),
    Delivery("delivery");

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static EventType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

