/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.IdentityType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentitiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListIdentitiesRequest> {
    private final String identityType;
    private final String nextToken;
    private final Integer maxItems;

    private ListIdentitiesRequest(BuilderImpl builder) {
        this.identityType = builder.identityType;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    public String identityType() {
        return this.identityType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityType() == null ? 0 : this.identityType().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesRequest)) {
            return false;
        }
        ListIdentitiesRequest other = (ListIdentitiesRequest)((Object)obj);
        if (other.identityType() == null ^ this.identityType() == null) {
            return false;
        }
        if (other.identityType() != null && !other.identityType().equals(this.identityType())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityType() != null) {
            sb.append("IdentityType: ").append(this.identityType()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityType;
        private String nextToken;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesRequest model) {
            this.setIdentityType(model.identityType);
            this.setNextToken(model.nextToken);
            this.setMaxItems(model.maxItems);
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public ListIdentitiesRequest build() {
            return new ListIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIdentitiesRequest> {
        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);
    }
}

