/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the body of the message. You can specify text, HTML, or both. If you use both, then the message should
 * display correctly in the widest variety of email clients.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Body implements ToCopyableBuilder<Body.Builder, Body> {
    private final Content text;

    private final Content html;

    private Body(BuilderImpl builder) {
        this.text = builder.text;
        this.html = builder.html;
    }

    /**
     * <p>
     * The content of the message, in text format. Use this for text-based email clients, or clients on high-latency
     * networks (such as mobile devices).
     * </p>
     * 
     * @return The content of the message, in text format. Use this for text-based email clients, or clients on
     *         high-latency networks (such as mobile devices).
     */
    public Content text() {
        return text;
    }

    /**
     * <p>
     * The content of the message, in HTML format. Use this for email clients that can process HTML. You can include
     * clickable links, formatted text, and much more in an HTML message.
     * </p>
     * 
     * @return The content of the message, in HTML format. Use this for email clients that can process HTML. You can
     *         include clickable links, formatted text, and much more in an HTML message.
     */
    public Content html() {
        return html;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((text() == null) ? 0 : text().hashCode());
        hashCode = 31 * hashCode + ((html() == null) ? 0 : html().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Body)) {
            return false;
        }
        Body other = (Body) obj;
        if (other.text() == null ^ this.text() == null) {
            return false;
        }
        if (other.text() != null && !other.text().equals(this.text())) {
            return false;
        }
        if (other.html() == null ^ this.html() == null) {
            return false;
        }
        if (other.html() != null && !other.html().equals(this.html())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (text() != null) {
            sb.append("Text: ").append(text()).append(",");
        }
        if (html() != null) {
            sb.append("Html: ").append(html()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.of(clazz.cast(text()));
        case "Html":
            return Optional.of(clazz.cast(html()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Body> {
        /**
         * <p>
         * The content of the message, in text format. Use this for text-based email clients, or clients on high-latency
         * networks (such as mobile devices).
         * </p>
         * 
         * @param text
         *        The content of the message, in text format. Use this for text-based email clients, or clients on
         *        high-latency networks (such as mobile devices).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(Content text);

        /**
         * <p>
         * The content of the message, in HTML format. Use this for email clients that can process HTML. You can include
         * clickable links, formatted text, and much more in an HTML message.
         * </p>
         * 
         * @param html
         *        The content of the message, in HTML format. Use this for email clients that can process HTML. You can
         *        include clickable links, formatted text, and much more in an HTML message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder html(Content html);
    }

    static final class BuilderImpl implements Builder {
        private Content text;

        private Content html;

        private BuilderImpl() {
        }

        private BuilderImpl(Body model) {
            text(model.text);
            html(model.html);
        }

        public final Content.Builder getText() {
            return text != null ? text.toBuilder() : null;
        }

        @Override
        public final Builder text(Content text) {
            this.text = text;
            return this;
        }

        public final void setText(Content.BuilderImpl text) {
            this.text = text != null ? text.build() : null;
        }

        public final Content.Builder getHtml() {
            return html != null ? html.toBuilder() : null;
        }

        @Override
        public final Builder html(Content html) {
            this.html = html;
            return this;
        }

        public final void setHtml(Content.BuilderImpl html) {
            this.html = html != null ? html.build() : null;
        }

        @Override
        public Body build() {
            return new Body(this);
        }
    }
}
