/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action rejects the received email by returning a bounce response to the sender
 * and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
 * </p>
 * <p>
 * For information about sending a bounce message in response to a received email, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BounceAction implements ToCopyableBuilder<BounceAction.Builder, BounceAction> {
    private final String topicArn;

    private final String smtpReplyCode;

    private final String statusCode;

    private final String message;

    private final String sender;

    private BounceAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.smtpReplyCode = builder.smtpReplyCode;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.sender = builder.sender;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An example of
     * an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     * Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     * Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An
     *         example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
     *         information about Amazon SNS topics, see the <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     * </p>
     * 
     * @return The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     */
    public String smtpReplyCode() {
        return smtpReplyCode;
    }

    /**
     * <p>
     * The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.
     * </p>
     * 
     * @return The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.
     */
    public String statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * Human-readable text to include in the bounce message.
     * </p>
     * 
     * @return Human-readable text to include in the bounce message.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The email address of the sender of the bounced email. This is the address from which the bounce message will be
     * sent.
     * </p>
     * 
     * @return The email address of the sender of the bounced email. This is the address from which the bounce message
     *         will be sent.
     */
    public String sender() {
        return sender;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((smtpReplyCode() == null) ? 0 : smtpReplyCode().hashCode());
        hashCode = 31 * hashCode + ((statusCode() == null) ? 0 : statusCode().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((sender() == null) ? 0 : sender().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BounceAction)) {
            return false;
        }
        BounceAction other = (BounceAction) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.smtpReplyCode() == null ^ this.smtpReplyCode() == null) {
            return false;
        }
        if (other.smtpReplyCode() != null && !other.smtpReplyCode().equals(this.smtpReplyCode())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.sender() == null ^ this.sender() == null) {
            return false;
        }
        if (other.sender() != null && !other.sender().equals(this.sender())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (smtpReplyCode() != null) {
            sb.append("SmtpReplyCode: ").append(smtpReplyCode()).append(",");
        }
        if (statusCode() != null) {
            sb.append("StatusCode: ").append(statusCode()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (sender() != null) {
            sb.append("Sender: ").append(sender()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        case "SmtpReplyCode":
            return Optional.of(clazz.cast(smtpReplyCode()));
        case "StatusCode":
            return Optional.of(clazz.cast(statusCode()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        case "Sender":
            return Optional.of(clazz.cast(sender()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, BounceAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An example
         * of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information
         * about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon
         * SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken. An
         *        example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
         *        more information about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * </p>
         * 
         * @param smtpReplyCode
         *        The SMTP reply code, as defined by <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smtpReplyCode(String smtpReplyCode);

        /**
         * <p>
         * The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC 3463</a>.
         * </p>
         * 
         * @param statusCode
         *        The SMTP enhanced status code, as defined by <a href="https://tools.ietf.org/html/rfc3463">RFC
         *        3463</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * Human-readable text to include in the bounce message.
         * </p>
         * 
         * @param message
         *        Human-readable text to include in the bounce message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The email address of the sender of the bounced email. This is the address from which the bounce message will
         * be sent.
         * </p>
         * 
         * @param sender
         *        The email address of the sender of the bounced email. This is the address from which the bounce
         *        message will be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);
    }

    static final class BuilderImpl implements Builder {
        private String topicArn;

        private String smtpReplyCode;

        private String statusCode;

        private String message;

        private String sender;

        private BuilderImpl() {
        }

        private BuilderImpl(BounceAction model) {
            topicArn(model.topicArn);
            smtpReplyCode(model.smtpReplyCode);
            statusCode(model.statusCode);
            message(model.message);
            sender(model.sender);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getSmtpReplyCode() {
            return smtpReplyCode;
        }

        @Override
        public final Builder smtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
            return this;
        }

        public final void setSmtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSender() {
            return sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public BounceAction build() {
            return new BounceAction(this);
        }
    }
}
