/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a configuration set. Configuration sets enable you to publish email sending events.
 * For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateConfigurationSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateConfigurationSetRequest.Builder, CreateConfigurationSetRequest> {
    private final ConfigurationSet configurationSet;

    private CreateConfigurationSetRequest(BuilderImpl builder) {
        this.configurationSet = builder.configurationSet;
    }

    /**
     * <p>
     * A data structure that contains the name of the configuration set.
     * </p>
     * 
     * @return A data structure that contains the name of the configuration set.
     */
    public ConfigurationSet configurationSet() {
        return configurationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSet() == null) ? 0 : configurationSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetRequest)) {
            return false;
        }
        CreateConfigurationSetRequest other = (CreateConfigurationSetRequest) obj;
        if (other.configurationSet() == null ^ this.configurationSet() == null) {
            return false;
        }
        if (other.configurationSet() != null && !other.configurationSet().equals(this.configurationSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationSet() != null) {
            sb.append("ConfigurationSet: ").append(configurationSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSet":
            return Optional.of(clazz.cast(configurationSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateConfigurationSetRequest> {
        /**
         * <p>
         * A data structure that contains the name of the configuration set.
         * </p>
         * 
         * @param configurationSet
         *        A data structure that contains the name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(ConfigurationSet configurationSet);
    }

    static final class BuilderImpl implements Builder {
        private ConfigurationSet configurationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetRequest model) {
            configurationSet(model.configurationSet);
        }

        public final ConfigurationSet.Builder getConfigurationSet() {
            return configurationSet != null ? configurationSet.toBuilder() : null;
        }

        @Override
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(ConfigurationSet.BuilderImpl configurationSet) {
            this.configurationSet = configurationSet != null ? configurationSet.build() : null;
        }

        @Override
        public CreateConfigurationSetRequest build() {
            return new CreateConfigurationSetRequest(this);
        }
    }
}
