/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For more
 * information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReceiptRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateReceiptRuleRequest.Builder, CreateReceiptRuleRequest> {
    private final String ruleSetName;

    private final String after;

    private final ReceiptRule rule;

    private CreateReceiptRuleRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.after = builder.after;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The name of the rule set to which to add the rule.
     * </p>
     * 
     * @return The name of the rule set to which to add the rule.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule
     * will be inserted at the beginning of the rule list.
     * </p>
     * 
     * @return The name of an existing rule after which the new rule will be placed. If this parameter is null, the new
     *         rule will be inserted at the beginning of the rule list.
     */
    public String after() {
        return after;
    }

    /**
     * <p>
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
     * status, and TLS policy.
     * </p>
     * 
     * @return A data structure that contains the specified rule's name, actions, recipients, domains, enabled status,
     *         scan status, and TLS policy.
     */
    public ReceiptRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleSetName() == null) ? 0 : ruleSetName().hashCode());
        hashCode = 31 * hashCode + ((after() == null) ? 0 : after().hashCode());
        hashCode = 31 * hashCode + ((rule() == null) ? 0 : rule().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptRuleRequest)) {
            return false;
        }
        CreateReceiptRuleRequest other = (CreateReceiptRuleRequest) obj;
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.after() == null ^ this.after() == null) {
            return false;
        }
        if (other.after() != null && !other.after().equals(this.after())) {
            return false;
        }
        if (other.rule() == null ^ this.rule() == null) {
            return false;
        }
        if (other.rule() != null && !other.rule().equals(this.rule())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ruleSetName() != null) {
            sb.append("RuleSetName: ").append(ruleSetName()).append(",");
        }
        if (after() != null) {
            sb.append("After: ").append(after()).append(",");
        }
        if (rule() != null) {
            sb.append("Rule: ").append(rule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.of(clazz.cast(ruleSetName()));
        case "After":
            return Optional.of(clazz.cast(after()));
        case "Rule":
            return Optional.of(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateReceiptRuleRequest> {
        /**
         * <p>
         * The name of the rule set to which to add the rule.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the rule set to which to add the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule
         * will be inserted at the beginning of the rule list.
         * </p>
         * 
         * @param after
         *        The name of an existing rule after which the new rule will be placed. If this parameter is null, the
         *        new rule will be inserted at the beginning of the rule list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(String after);

        /**
         * <p>
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
         * status, and TLS policy.
         * </p>
         * 
         * @param rule
         *        A data structure that contains the specified rule's name, actions, recipients, domains, enabled
         *        status, scan status, and TLS policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ReceiptRule rule);
    }

    static final class BuilderImpl implements Builder {
        private String ruleSetName;

        private String after;

        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptRuleRequest model) {
            ruleSetName(model.ruleSetName);
            after(model.after);
            rule(model.rule);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getAfter() {
            return after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        public final ReceiptRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public CreateReceiptRuleRequest build() {
            return new CreateReceiptRuleRequest(this);
        }
    }
}
