/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete an IP address filter. You use IP address filters when you receive email with Amazon
 * SES. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteReceiptFilterRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteReceiptFilterRequest.Builder, DeleteReceiptFilterRequest> {
    private final String filterName;

    private DeleteReceiptFilterRequest(BuilderImpl builder) {
        this.filterName = builder.filterName;
    }

    /**
     * <p>
     * The name of the IP address filter to delete.
     * </p>
     * 
     * @return The name of the IP address filter to delete.
     */
    public String filterName() {
        return filterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filterName() == null) ? 0 : filterName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReceiptFilterRequest)) {
            return false;
        }
        DeleteReceiptFilterRequest other = (DeleteReceiptFilterRequest) obj;
        if (other.filterName() == null ^ this.filterName() == null) {
            return false;
        }
        if (other.filterName() != null && !other.filterName().equals(this.filterName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filterName() != null) {
            sb.append("FilterName: ").append(filterName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterName":
            return Optional.of(clazz.cast(filterName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteReceiptFilterRequest> {
        /**
         * <p>
         * The name of the IP address filter to delete.
         * </p>
         * 
         * @param filterName
         *        The name of the IP address filter to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);
    }

    static final class BuilderImpl implements Builder {
        private String filterName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReceiptFilterRequest model) {
            filterName(model.filterName);
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public DeleteReceiptFilterRequest build() {
            return new DeleteReceiptFilterRequest(this);
        }
    }
}
