/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return the details of a configuration set. Configuration sets enable you to publish email
 * sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConfigurationSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeConfigurationSetRequest.Builder, DescribeConfigurationSetRequest> {
    private final String configurationSetName;

    private final List<String> configurationSetAttributeNames;

    private DescribeConfigurationSetRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
        this.configurationSetAttributeNames = builder.configurationSetAttributeNames;
    }

    /**
     * <p>
     * The name of the configuration set to describe.
     * </p>
     * 
     * @return The name of the configuration set to describe.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * A list of configuration set attributes to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of configuration set attributes to return.
     */
    public List<ConfigurationSetAttribute> configurationSetAttributeNames() {
        return TypeConverter.convert(configurationSetAttributeNames, ConfigurationSetAttribute::fromValue);
    }

    /**
     * <p>
     * A list of configuration set attributes to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of configuration set attributes to return.
     */
    public List<String> configurationSetAttributeNamesStrings() {
        return configurationSetAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSetName() == null) ? 0 : configurationSetName().hashCode());
        hashCode = 31 * hashCode
                + ((configurationSetAttributeNamesStrings() == null) ? 0 : configurationSetAttributeNamesStrings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetRequest)) {
            return false;
        }
        DescribeConfigurationSetRequest other = (DescribeConfigurationSetRequest) obj;
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        if (other.configurationSetName() != null && !other.configurationSetName().equals(this.configurationSetName())) {
            return false;
        }
        if (other.configurationSetAttributeNamesStrings() == null ^ this.configurationSetAttributeNamesStrings() == null) {
            return false;
        }
        if (other.configurationSetAttributeNamesStrings() != null
                && !other.configurationSetAttributeNamesStrings().equals(this.configurationSetAttributeNamesStrings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(configurationSetName()).append(",");
        }
        if (configurationSetAttributeNamesStrings() != null) {
            sb.append("ConfigurationSetAttributeNames: ").append(configurationSetAttributeNamesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.of(clazz.cast(configurationSetName()));
        case "ConfigurationSetAttributeNames":
            return Optional.of(clazz.cast(configurationSetAttributeNamesStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeConfigurationSetRequest> {
        /**
         * <p>
         * The name of the configuration set to describe.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * A list of configuration set attributes to return.
         * </p>
         * 
         * @param configurationSetAttributeNames
         *        A list of configuration set attributes to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetAttributeNames(Collection<String> configurationSetAttributeNames);

        /**
         * <p>
         * A list of configuration set attributes to return.
         * </p>
         * 
         * @param configurationSetAttributeNames
         *        A list of configuration set attributes to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetAttributeNames(String... configurationSetAttributeNames);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private List<String> configurationSetAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetRequest model) {
            configurationSetName(model.configurationSetName);
            configurationSetAttributeNames(model.configurationSetAttributeNames);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final Collection<String> getConfigurationSetAttributeNames() {
            return configurationSetAttributeNames;
        }

        @Override
        public final Builder configurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSetAttributeNames(String... configurationSetAttributeNames) {
            configurationSetAttributeNames(Arrays.asList(configurationSetAttributeNames));
            return this;
        }

        public final void setConfigurationSetAttributeNames(Collection<String> configurationSetAttributeNames) {
            this.configurationSetAttributeNames = ConfigurationSetAttributeListCopier.copy(configurationSetAttributeNames);
        }

        @Override
        public DescribeConfigurationSetRequest build() {
            return new DescribeConfigurationSetRequest(this);
        }
    }
}
