/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return the details of a receipt rule. You use receipt rules to receive email with Amazon SES.
 * For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReceiptRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeReceiptRuleRequest.Builder, DescribeReceiptRuleRequest> {
    private final String ruleSetName;

    private final String ruleName;

    private DescribeReceiptRuleRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
    }

    /**
     * <p>
     * The name of the receipt rule set to which the receipt rule belongs.
     * </p>
     * 
     * @return The name of the receipt rule set to which the receipt rule belongs.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of the receipt rule.
     * </p>
     * 
     * @return The name of the receipt rule.
     */
    public String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleSetName() == null) ? 0 : ruleSetName().hashCode());
        hashCode = 31 * hashCode + ((ruleName() == null) ? 0 : ruleName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleRequest)) {
            return false;
        }
        DescribeReceiptRuleRequest other = (DescribeReceiptRuleRequest) obj;
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        if (other.ruleName() != null && !other.ruleName().equals(this.ruleName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ruleSetName() != null) {
            sb.append("RuleSetName: ").append(ruleSetName()).append(",");
        }
        if (ruleName() != null) {
            sb.append("RuleName: ").append(ruleName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.of(clazz.cast(ruleSetName()));
        case "RuleName":
            return Optional.of(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReceiptRuleRequest> {
        /**
         * <p>
         * The name of the receipt rule set to which the receipt rule belongs.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set to which the receipt rule belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of the receipt rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the receipt rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);
    }

    static final class BuilderImpl implements Builder {
        private String ruleSetName;

        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleRequest model) {
            ruleSetName(model.ruleSetName);
            ruleName(model.ruleName);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public DescribeReceiptRuleRequest build() {
            return new DescribeReceiptRuleRequest(this);
        }
    }
}
