/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the provided AWS Lambda function is invalid, or that Amazon SES could not execute the provided
 * function, possibly due to permissions issues. For information about giving permissions, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidLambdaFunctionException extends SESException implements
        ToCopyableBuilder<InvalidLambdaFunctionException.Builder, InvalidLambdaFunctionException> {
    private final String functionArn;

    private InvalidLambdaFunctionException(BuilderImpl builder) {
        super(builder.message);
        this.functionArn = builder.functionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the FunctionArn property for this object.
     * 
     * @return The value of the FunctionArn property for this object.
     */
    public String functionArn() {
        return functionArn;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidLambdaFunctionException> {
        /**
         * Sets the value of the FunctionArn property for this object.
         *
         * @param functionArn
         *        The new value for the FunctionArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String functionArn;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidLambdaFunctionException model) {
            functionArn(model.functionArn);
            this.message = model.getMessage();
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidLambdaFunctionException build() {
            return new InvalidLambdaFunctionException(this);
        }
    }
}
