/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
 * </p>
 * <p>
 * Event destinations, such as Amazon Kinesis Firehose, are associated with configuration sets, which enable you to
 * publish email sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisFirehoseDestination implements
        ToCopyableBuilder<KinesisFirehoseDestination.Builder, KinesisFirehoseDestination> {
    private final String iamRoleARN;

    private final String deliveryStreamARN;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.iamRoleARN = builder.iamRoleARN;
        this.deliveryStreamARN = builder.deliveryStreamARN;
    }

    /**
     * <p>
     * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
     * stream.
     * </p>
     * 
     * @return The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis
     *         Firehose stream.
     */
    public String iamRoleARN() {
        return iamRoleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon Kinesis Firehose stream to which to publish email sending events.
     * </p>
     * 
     * @return The ARN of the Amazon Kinesis Firehose stream to which to publish email sending events.
     */
    public String deliveryStreamARN() {
        return deliveryStreamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((iamRoleARN() == null) ? 0 : iamRoleARN().hashCode());
        hashCode = 31 * hashCode + ((deliveryStreamARN() == null) ? 0 : deliveryStreamARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination) obj;
        if (other.iamRoleARN() == null ^ this.iamRoleARN() == null) {
            return false;
        }
        if (other.iamRoleARN() != null && !other.iamRoleARN().equals(this.iamRoleARN())) {
            return false;
        }
        if (other.deliveryStreamARN() == null ^ this.deliveryStreamARN() == null) {
            return false;
        }
        if (other.deliveryStreamARN() != null && !other.deliveryStreamARN().equals(this.deliveryStreamARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (iamRoleARN() != null) {
            sb.append("IAMRoleARN: ").append(iamRoleARN()).append(",");
        }
        if (deliveryStreamARN() != null) {
            sb.append("DeliveryStreamARN: ").append(deliveryStreamARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IAMRoleARN":
            return Optional.of(clazz.cast(iamRoleARN()));
        case "DeliveryStreamARN":
            return Optional.of(clazz.cast(deliveryStreamARN()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisFirehoseDestination> {
        /**
         * <p>
         * The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose
         * stream.
         * </p>
         * 
         * @param iamRoleARN
         *        The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis
         *        Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleARN(String iamRoleARN);

        /**
         * <p>
         * The ARN of the Amazon Kinesis Firehose stream to which to publish email sending events.
         * </p>
         * 
         * @param deliveryStreamARN
         *        The ARN of the Amazon Kinesis Firehose stream to which to publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamARN(String deliveryStreamARN);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleARN;

        private String deliveryStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            iamRoleARN(model.iamRoleARN);
            deliveryStreamARN(model.deliveryStreamARN);
        }

        public final String getIAMRoleARN() {
            return iamRoleARN;
        }

        @Override
        public final Builder iamRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
            return this;
        }

        public final void setIAMRoleARN(String iamRoleARN) {
            this.iamRoleARN = iamRoleARN;
        }

        public final String getDeliveryStreamARN() {
            return deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        @Override
        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }
    }
}
