/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action that Amazon SES can take when it receives an email on behalf of one or more email addresses or domains that
 * you own. An instance of this data type can represent only one action.
 * </p>
 * <p>
 * For information about setting up receipt rules, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiptAction implements ToCopyableBuilder<ReceiptAction.Builder, ReceiptAction> {
    private final S3Action s3Action;

    private final BounceAction bounceAction;

    private final WorkmailAction workmailAction;

    private final LambdaAction lambdaAction;

    private final StopAction stopAction;

    private final AddHeaderAction addHeaderAction;

    private final SNSAction snsAction;

    private ReceiptAction(BuilderImpl builder) {
        this.s3Action = builder.s3Action;
        this.bounceAction = builder.bounceAction;
        this.workmailAction = builder.workmailAction;
        this.lambdaAction = builder.lambdaAction;
        this.stopAction = builder.stopAction;
        this.addHeaderAction = builder.addHeaderAction;
        this.snsAction = builder.snsAction;
    }

    /**
     * <p>
     * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a
     * notification to Amazon SNS.
     * </p>
     * 
     * @return Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally,
     *         publishes a notification to Amazon SNS.
     */
    public S3Action s3Action() {
        return s3Action;
    }

    /**
     * <p>
     * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification
     * to Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * 
     * @return Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
     *         notification to Amazon Simple Notification Service (Amazon SNS).
     */
    public BounceAction bounceAction() {
        return bounceAction;
    }

    /**
     * <p>
     * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
     * </p>
     * 
     * @return Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
     */
    public WorkmailAction workmailAction() {
        return workmailAction;
    }

    /**
     * <p>
     * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     * </p>
     * 
     * @return Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     */
    public LambdaAction lambdaAction() {
        return lambdaAction;
    }

    /**
     * <p>
     * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     * </p>
     * 
     * @return Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     */
    public StopAction stopAction() {
        return stopAction;
    }

    /**
     * <p>
     * Adds a header to the received email.
     * </p>
     * 
     * @return Adds a header to the received email.
     */
    public AddHeaderAction addHeaderAction() {
        return addHeaderAction;
    }

    /**
     * <p>
     * Publishes the email content within a notification to Amazon SNS.
     * </p>
     * 
     * @return Publishes the email content within a notification to Amazon SNS.
     */
    public SNSAction snsAction() {
        return snsAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s3Action() == null) ? 0 : s3Action().hashCode());
        hashCode = 31 * hashCode + ((bounceAction() == null) ? 0 : bounceAction().hashCode());
        hashCode = 31 * hashCode + ((workmailAction() == null) ? 0 : workmailAction().hashCode());
        hashCode = 31 * hashCode + ((lambdaAction() == null) ? 0 : lambdaAction().hashCode());
        hashCode = 31 * hashCode + ((stopAction() == null) ? 0 : stopAction().hashCode());
        hashCode = 31 * hashCode + ((addHeaderAction() == null) ? 0 : addHeaderAction().hashCode());
        hashCode = 31 * hashCode + ((snsAction() == null) ? 0 : snsAction().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptAction)) {
            return false;
        }
        ReceiptAction other = (ReceiptAction) obj;
        if (other.s3Action() == null ^ this.s3Action() == null) {
            return false;
        }
        if (other.s3Action() != null && !other.s3Action().equals(this.s3Action())) {
            return false;
        }
        if (other.bounceAction() == null ^ this.bounceAction() == null) {
            return false;
        }
        if (other.bounceAction() != null && !other.bounceAction().equals(this.bounceAction())) {
            return false;
        }
        if (other.workmailAction() == null ^ this.workmailAction() == null) {
            return false;
        }
        if (other.workmailAction() != null && !other.workmailAction().equals(this.workmailAction())) {
            return false;
        }
        if (other.lambdaAction() == null ^ this.lambdaAction() == null) {
            return false;
        }
        if (other.lambdaAction() != null && !other.lambdaAction().equals(this.lambdaAction())) {
            return false;
        }
        if (other.stopAction() == null ^ this.stopAction() == null) {
            return false;
        }
        if (other.stopAction() != null && !other.stopAction().equals(this.stopAction())) {
            return false;
        }
        if (other.addHeaderAction() == null ^ this.addHeaderAction() == null) {
            return false;
        }
        if (other.addHeaderAction() != null && !other.addHeaderAction().equals(this.addHeaderAction())) {
            return false;
        }
        if (other.snsAction() == null ^ this.snsAction() == null) {
            return false;
        }
        if (other.snsAction() != null && !other.snsAction().equals(this.snsAction())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (s3Action() != null) {
            sb.append("S3Action: ").append(s3Action()).append(",");
        }
        if (bounceAction() != null) {
            sb.append("BounceAction: ").append(bounceAction()).append(",");
        }
        if (workmailAction() != null) {
            sb.append("WorkmailAction: ").append(workmailAction()).append(",");
        }
        if (lambdaAction() != null) {
            sb.append("LambdaAction: ").append(lambdaAction()).append(",");
        }
        if (stopAction() != null) {
            sb.append("StopAction: ").append(stopAction()).append(",");
        }
        if (addHeaderAction() != null) {
            sb.append("AddHeaderAction: ").append(addHeaderAction()).append(",");
        }
        if (snsAction() != null) {
            sb.append("SNSAction: ").append(snsAction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Action":
            return Optional.of(clazz.cast(s3Action()));
        case "BounceAction":
            return Optional.of(clazz.cast(bounceAction()));
        case "WorkmailAction":
            return Optional.of(clazz.cast(workmailAction()));
        case "LambdaAction":
            return Optional.of(clazz.cast(lambdaAction()));
        case "StopAction":
            return Optional.of(clazz.cast(stopAction()));
        case "AddHeaderAction":
            return Optional.of(clazz.cast(addHeaderAction()));
        case "SNSAction":
            return Optional.of(clazz.cast(snsAction()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiptAction> {
        /**
         * <p>
         * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
         * a notification to Amazon SNS.
         * </p>
         * 
         * @param s3Action
         *        Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally,
         *        publishes a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Action(S3Action s3Action);

        /**
         * <p>
         * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
         * notification to Amazon Simple Notification Service (Amazon SNS).
         * </p>
         * 
         * @param bounceAction
         *        Rejects the received email by returning a bounce response to the sender and, optionally, publishes a
         *        notification to Amazon Simple Notification Service (Amazon SNS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounceAction(BounceAction bounceAction);

        /**
         * <p>
         * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
         * </p>
         * 
         * @param workmailAction
         *        Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workmailAction(WorkmailAction workmailAction);

        /**
         * <p>
         * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
         * </p>
         * 
         * @param lambdaAction
         *        Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAction(LambdaAction lambdaAction);

        /**
         * <p>
         * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
         * </p>
         * 
         * @param stopAction
         *        Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon
         *        SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopAction(StopAction stopAction);

        /**
         * <p>
         * Adds a header to the received email.
         * </p>
         * 
         * @param addHeaderAction
         *        Adds a header to the received email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addHeaderAction(AddHeaderAction addHeaderAction);

        /**
         * <p>
         * Publishes the email content within a notification to Amazon SNS.
         * </p>
         * 
         * @param snsAction
         *        Publishes the email content within a notification to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsAction(SNSAction snsAction);
    }

    static final class BuilderImpl implements Builder {
        private S3Action s3Action;

        private BounceAction bounceAction;

        private WorkmailAction workmailAction;

        private LambdaAction lambdaAction;

        private StopAction stopAction;

        private AddHeaderAction addHeaderAction;

        private SNSAction snsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptAction model) {
            s3Action(model.s3Action);
            bounceAction(model.bounceAction);
            workmailAction(model.workmailAction);
            lambdaAction(model.lambdaAction);
            stopAction(model.stopAction);
            addHeaderAction(model.addHeaderAction);
            snsAction(model.snsAction);
        }

        public final S3Action.Builder getS3Action() {
            return s3Action != null ? s3Action.toBuilder() : null;
        }

        @Override
        public final Builder s3Action(S3Action s3Action) {
            this.s3Action = s3Action;
            return this;
        }

        public final void setS3Action(S3Action.BuilderImpl s3Action) {
            this.s3Action = s3Action != null ? s3Action.build() : null;
        }

        public final BounceAction.Builder getBounceAction() {
            return bounceAction != null ? bounceAction.toBuilder() : null;
        }

        @Override
        public final Builder bounceAction(BounceAction bounceAction) {
            this.bounceAction = bounceAction;
            return this;
        }

        public final void setBounceAction(BounceAction.BuilderImpl bounceAction) {
            this.bounceAction = bounceAction != null ? bounceAction.build() : null;
        }

        public final WorkmailAction.Builder getWorkmailAction() {
            return workmailAction != null ? workmailAction.toBuilder() : null;
        }

        @Override
        public final Builder workmailAction(WorkmailAction workmailAction) {
            this.workmailAction = workmailAction;
            return this;
        }

        public final void setWorkmailAction(WorkmailAction.BuilderImpl workmailAction) {
            this.workmailAction = workmailAction != null ? workmailAction.build() : null;
        }

        public final LambdaAction.Builder getLambdaAction() {
            return lambdaAction != null ? lambdaAction.toBuilder() : null;
        }

        @Override
        public final Builder lambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
            return this;
        }

        public final void setLambdaAction(LambdaAction.BuilderImpl lambdaAction) {
            this.lambdaAction = lambdaAction != null ? lambdaAction.build() : null;
        }

        public final StopAction.Builder getStopAction() {
            return stopAction != null ? stopAction.toBuilder() : null;
        }

        @Override
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        public final void setStopAction(StopAction.BuilderImpl stopAction) {
            this.stopAction = stopAction != null ? stopAction.build() : null;
        }

        public final AddHeaderAction.Builder getAddHeaderAction() {
            return addHeaderAction != null ? addHeaderAction.toBuilder() : null;
        }

        @Override
        public final Builder addHeaderAction(AddHeaderAction addHeaderAction) {
            this.addHeaderAction = addHeaderAction;
            return this;
        }

        public final void setAddHeaderAction(AddHeaderAction.BuilderImpl addHeaderAction) {
            this.addHeaderAction = addHeaderAction != null ? addHeaderAction.build() : null;
        }

        public final SNSAction.Builder getSNSAction() {
            return snsAction != null ? snsAction.toBuilder() : null;
        }

        @Override
        public final Builder snsAction(SNSAction snsAction) {
            this.snsAction = snsAction;
            return this;
        }

        public final void setSNSAction(SNSAction.BuilderImpl snsAction) {
            this.snsAction = snsAction != null ? snsAction.build() : null;
        }

        @Override
        public ReceiptAction build() {
            return new ReceiptAction(this);
        }
    }
}
