/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to set whether Amazon SES includes the original email headers in the Amazon SNS notifications of
 * a specified type. For information about notifications, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetIdentityHeadersInNotificationsEnabledRequest extends AmazonWebServiceRequest
        implements
        ToCopyableBuilder<SetIdentityHeadersInNotificationsEnabledRequest.Builder, SetIdentityHeadersInNotificationsEnabledRequest> {
    private final String identity;

    private final String notificationType;

    private final Boolean enabled;

    private SetIdentityHeadersInNotificationsEnabledRequest(BuilderImpl builder) {
        this.identity = builder.identity;
        this.notificationType = builder.notificationType;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The identity for which to enable or disable headers in notifications. Examples: <code>user@example.com</code>,
     * <code>example.com</code>.
     * </p>
     * 
     * @return The identity for which to enable or disable headers in notifications. Examples:
     *         <code>user@example.com</code>, <code>example.com</code>.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * The notification type for which to enable or disable headers in notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeString}.
     * </p>
     * 
     * @return The notification type for which to enable or disable headers in notifications.
     * @see NotificationType
     */
    public NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * <p>
     * The notification type for which to enable or disable headers in notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeString}.
     * </p>
     * 
     * @return The notification type for which to enable or disable headers in notifications.
     * @see NotificationType
     */
    public String notificationTypeString() {
        return notificationType;
    }

    /**
     * <p>
     * Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified
     * notification type. A value of <code>true</code> specifies that Amazon SES will include headers in notifications,
     * and a value of <code>false</code> specifies that Amazon SES will not include headers in notifications.
     * </p>
     * <p>
     * This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon SNS
     * topic.
     * </p>
     * 
     * @return Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified
     *         notification type. A value of <code>true</code> specifies that Amazon SES will include headers in
     *         notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in
     *         notifications.</p>
     *         <p>
     *         This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon
     *         SNS topic.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        hashCode = 31 * hashCode + ((notificationTypeString() == null) ? 0 : notificationTypeString().hashCode());
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityHeadersInNotificationsEnabledRequest)) {
            return false;
        }
        SetIdentityHeadersInNotificationsEnabledRequest other = (SetIdentityHeadersInNotificationsEnabledRequest) obj;
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.notificationTypeString() == null ^ this.notificationTypeString() == null) {
            return false;
        }
        if (other.notificationTypeString() != null && !other.notificationTypeString().equals(this.notificationTypeString())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (notificationTypeString() != null) {
            sb.append("NotificationType: ").append(notificationTypeString()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.of(clazz.cast(identity()));
        case "NotificationType":
            return Optional.of(clazz.cast(notificationTypeString()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SetIdentityHeadersInNotificationsEnabledRequest> {
        /**
         * <p>
         * The identity for which to enable or disable headers in notifications. Examples: <code>user@example.com</code>, <code>example.com</code>.
         * </p>
         * 
         * @param identity
         *        The identity for which to enable or disable headers in notifications. Examples:
         *        <code>user@example.com</code>, <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * The notification type for which to enable or disable headers in notifications.
         * </p>
         * 
         * @param notificationType
         *        The notification type for which to enable or disable headers in notifications.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * The notification type for which to enable or disable headers in notifications.
         * </p>
         * 
         * @param notificationType
         *        The notification type for which to enable or disable headers in notifications.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);

        /**
         * <p>
         * Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified
         * notification type. A value of <code>true</code> specifies that Amazon SES will include headers in
         * notifications, and a value of <code>false</code> specifies that Amazon SES will not include headers in
         * notifications.
         * </p>
         * <p>
         * This value can only be set when <code>NotificationType</code> is already set to use a particular Amazon SNS
         * topic.
         * </p>
         * 
         * @param enabled
         *        Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the
         *        specified notification type. A value of <code>true</code> specifies that Amazon SES will include
         *        headers in notifications, and a value of <code>false</code> specifies that Amazon SES will not include
         *        headers in notifications.</p>
         *        <p>
         *        This value can only be set when <code>NotificationType</code> is already set to use a particular
         *        Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String identity;

        private String notificationType;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityHeadersInNotificationsEnabledRequest model) {
            identity(model.identity);
            notificationType(model.notificationType);
            enabled(model.enabled);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public SetIdentityHeadersInNotificationsEnabledRequest build() {
            return new SetIdentityHeadersInNotificationsEnabledRequest(this);
        }
    }
}
