/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action terminates the evaluation of the receipt rule set and, optionally,
 * publishes a notification to Amazon Simple Notification Service (Amazon SNS).
 * </p>
 * <p>
 * For information about setting a stop action in a receipt rule, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopAction implements ToCopyableBuilder<StopAction.Builder, StopAction> {
    private final String scope;

    private final String topicArn;

    private StopAction(BuilderImpl builder) {
        this.scope = builder.scope;
        this.topicArn = builder.topicArn;
    }

    /**
     * <p>
     * The scope to which the Stop action applies. That is, what is being stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link StopScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeString}.
     * </p>
     * 
     * @return The scope to which the Stop action applies. That is, what is being stopped.
     * @see StopScope
     */
    public StopScope scope() {
        return StopScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope to which the Stop action applies. That is, what is being stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link StopScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeString}.
     * </p>
     * 
     * @return The scope to which the Stop action applies. That is, what is being stopped.
     * @see StopScope
     */
    public String scopeString() {
        return scope;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken. An example of an
     * Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     * Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     * Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken. An
     *         example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
     *         information about Amazon SNS topics, see the <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public String topicArn() {
        return topicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((scopeString() == null) ? 0 : scopeString().hashCode());
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopAction)) {
            return false;
        }
        StopAction other = (StopAction) obj;
        if (other.scopeString() == null ^ this.scopeString() == null) {
            return false;
        }
        if (other.scopeString() != null && !other.scopeString().equals(this.scopeString())) {
            return false;
        }
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (scopeString() != null) {
            sb.append("Scope: ").append(scopeString()).append(",");
        }
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.of(clazz.cast(scopeString()));
        case "TopicArn":
            return Optional.of(clazz.cast(topicArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StopAction> {
        /**
         * <p>
         * The scope to which the Stop action applies. That is, what is being stopped.
         * </p>
         * 
         * @param scope
         *        The scope to which the Stop action applies. That is, what is being stopped.
         * @see StopScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope to which the Stop action applies. That is, what is being stopped.
         * </p>
         * 
         * @param scope
         *        The scope to which the Stop action applies. That is, what is being stopped.
         * @see StopScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopScope
         */
        Builder scope(StopScope scope);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken. An example of
         * an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information
         * about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon
         * SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken. An
         *        example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
         *        more information about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);
    }

    static final class BuilderImpl implements Builder {
        private String scope;

        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StopAction model) {
            scope(model.scope);
            topicArn(model.topicArn);
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(StopScope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public StopAction build() {
            return new StopAction(this);
        }
    }
}
