/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to begin email address verification with Amazon SES. For information about email address
 * verification, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VerifyEmailAddressRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<VerifyEmailAddressRequest.Builder, VerifyEmailAddressRequest> {
    private final String emailAddress;

    private VerifyEmailAddressRequest(BuilderImpl builder) {
        this.emailAddress = builder.emailAddress;
    }

    /**
     * <p>
     * The email address to be verified.
     * </p>
     * 
     * @return The email address to be verified.
     */
    public String emailAddress() {
        return emailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((emailAddress() == null) ? 0 : emailAddress().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyEmailAddressRequest)) {
            return false;
        }
        VerifyEmailAddressRequest other = (VerifyEmailAddressRequest) obj;
        if (other.emailAddress() == null ^ this.emailAddress() == null) {
            return false;
        }
        if (other.emailAddress() != null && !other.emailAddress().equals(this.emailAddress())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (emailAddress() != null) {
            sb.append("EmailAddress: ").append(emailAddress()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddress":
            return Optional.of(clazz.cast(emailAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VerifyEmailAddressRequest> {
        /**
         * <p>
         * The email address to be verified.
         * </p>
         * 
         * @param emailAddress
         *        The email address to be verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);
    }

    static final class BuilderImpl implements Builder {
        private String emailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyEmailAddressRequest model) {
            emailAddress(model.emailAddress);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public VerifyEmailAddressRequest build() {
            return new VerifyEmailAddressRequest(this);
        }
    }
}
