/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateReceiptFilterRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateReceiptFilterRequestMarshaller implements
        Marshaller<Request<CreateReceiptFilterRequest>, CreateReceiptFilterRequest> {

    public Request<CreateReceiptFilterRequest> marshall(CreateReceiptFilterRequest createReceiptFilterRequest) {

        if (createReceiptFilterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateReceiptFilterRequest> request = new DefaultRequest<CreateReceiptFilterRequest>(createReceiptFilterRequest,
                "SESClient");
        request.addParameter("Action", "CreateReceiptFilter");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        ReceiptFilter filter = createReceiptFilterRequest.filter();
        if (filter != null) {

            if (filter.name() != null) {
                request.addParameter("Filter.Name", StringUtils.fromString(filter.name()));
            }

            ReceiptIpFilter ipFilter = filter.ipFilter();
            if (ipFilter != null) {

                if (ipFilter.policyString() != null) {
                    request.addParameter("Filter.IpFilter.Policy", StringUtils.fromString(ipFilter.policyString()));
                }

                if (ipFilter.cidr() != null) {
                    request.addParameter("Filter.IpFilter.Cidr", StringUtils.fromString(ipFilter.cidr()));
                }
            }
        }

        return request;
    }

}
