/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ReorderReceiptRuleSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReorderReceiptRuleSetRequestMarshaller implements
        Marshaller<Request<ReorderReceiptRuleSetRequest>, ReorderReceiptRuleSetRequest> {

    public Request<ReorderReceiptRuleSetRequest> marshall(ReorderReceiptRuleSetRequest reorderReceiptRuleSetRequest) {

        if (reorderReceiptRuleSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ReorderReceiptRuleSetRequest> request = new DefaultRequest<ReorderReceiptRuleSetRequest>(
                reorderReceiptRuleSetRequest, "SESClient");
        request.addParameter("Action", "ReorderReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (reorderReceiptRuleSetRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString(reorderReceiptRuleSetRequest.ruleSetName()));
        }

        java.util.List<String> ruleNamesList = reorderReceiptRuleSetRequest.ruleNames();

        if (ruleNamesList != null) {
            if (!ruleNamesList.isEmpty()) {
                int ruleNamesListIndex = 1;

                for (String ruleNamesListValue : ruleNamesList) {
                    if (ruleNamesListValue != null) {
                        request.addParameter("RuleNames.member." + ruleNamesListIndex, StringUtils.fromString(ruleNamesListValue));
                    }
                    ruleNamesListIndex++;
                }
            } else {
                request.addParameter("RuleNames", "");
            }
        }

        return request;
    }

}
