/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes;
import software.amazon.awssdk.services.ses.model.NotificationAttributesCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityNotificationAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        this.notificationAttributes = builder.notificationAttributes;
    }

    public Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return this.notificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notificationAttributes() == null ? 0 : this.notificationAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse)((Object)obj);
        if (other.notificationAttributes() == null ^ this.notificationAttributes() == null) {
            return false;
        }
        return other.notificationAttributes() == null || other.notificationAttributes().equals(this.notificationAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.notificationAttributes() != null) {
            sb.append("NotificationAttributes: ").append(this.notificationAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationAttributes": {
                return Optional.of(clazz.cast(this.notificationAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            this.notificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes.Builder> getNotificationAttributes() {
            return this.notificationAttributes != null ? CollectionUtils.mapValues(this.notificationAttributes, IdentityNotificationAttributes::toBuilder) : null;
        }

        @Override
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes.BuilderImpl> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copyFromBuilder(notificationAttributes);
        }

        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        public Builder notificationAttributes(Map<String, IdentityNotificationAttributes> var1);
    }
}

