/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutIdentityPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutIdentityPolicyRequest> {
    private final String identity;
    private final String policyName;
    private final String policy;

    private PutIdentityPolicyRequest(BuilderImpl builder) {
        this.identity = builder.identity;
        this.policyName = builder.policyName;
        this.policy = builder.policy;
    }

    public String identity() {
        return this.identity;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identity() == null ? 0 : this.identity().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policy() == null ? 0 : this.policy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIdentityPolicyRequest)) {
            return false;
        }
        PutIdentityPolicyRequest other = (PutIdentityPolicyRequest)((Object)obj);
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        return other.policy() == null || other.policy().equals(this.policy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identity() != null) {
            sb.append("Identity: ").append(this.identity()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policy() != null) {
            sb.append("Policy: ").append(this.policy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identity;
        private String policyName;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIdentityPolicyRequest model) {
            this.identity(model.identity);
            this.policyName(model.policyName);
            this.policy(model.policy);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public PutIdentityPolicyRequest build() {
            return new PutIdentityPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutIdentityPolicyRequest> {
        public Builder identity(String var1);

        public Builder policyName(String var1);

        public Builder policy(String var1);
    }
}

