/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendRawEmailRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendRawEmailRequest> {
    private final String source;
    private final List<String> destinations;
    private final RawMessage rawMessage;
    private final String fromArn;
    private final String sourceArn;
    private final String returnPathArn;
    private final List<MessageTag> tags;
    private final String configurationSetName;

    private SendRawEmailRequest(BuilderImpl builder) {
        this.source = builder.source;
        this.destinations = builder.destinations;
        this.rawMessage = builder.rawMessage;
        this.fromArn = builder.fromArn;
        this.sourceArn = builder.sourceArn;
        this.returnPathArn = builder.returnPathArn;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
    }

    public String source() {
        return this.source;
    }

    public List<String> destinations() {
        return this.destinations;
    }

    public RawMessage rawMessage() {
        return this.rawMessage;
    }

    public String fromArn() {
        return this.fromArn;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String returnPathArn() {
        return this.returnPathArn;
    }

    public List<MessageTag> tags() {
        return this.tags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.destinations() == null ? 0 : this.destinations().hashCode());
        hashCode = 31 * hashCode + (this.rawMessage() == null ? 0 : this.rawMessage().hashCode());
        hashCode = 31 * hashCode + (this.fromArn() == null ? 0 : this.fromArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceArn() == null ? 0 : this.sourceArn().hashCode());
        hashCode = 31 * hashCode + (this.returnPathArn() == null ? 0 : this.returnPathArn().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.configurationSetName() == null ? 0 : this.configurationSetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendRawEmailRequest)) {
            return false;
        }
        SendRawEmailRequest other = (SendRawEmailRequest)((Object)obj);
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        if (other.destinations() != null && !other.destinations().equals(this.destinations())) {
            return false;
        }
        if (other.rawMessage() == null ^ this.rawMessage() == null) {
            return false;
        }
        if (other.rawMessage() != null && !other.rawMessage().equals(this.rawMessage())) {
            return false;
        }
        if (other.fromArn() == null ^ this.fromArn() == null) {
            return false;
        }
        if (other.fromArn() != null && !other.fromArn().equals(this.fromArn())) {
            return false;
        }
        if (other.sourceArn() == null ^ this.sourceArn() == null) {
            return false;
        }
        if (other.sourceArn() != null && !other.sourceArn().equals(this.sourceArn())) {
            return false;
        }
        if (other.returnPathArn() == null ^ this.returnPathArn() == null) {
            return false;
        }
        if (other.returnPathArn() != null && !other.returnPathArn().equals(this.returnPathArn())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        return other.configurationSetName() == null || other.configurationSetName().equals(this.configurationSetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.destinations() != null) {
            sb.append("Destinations: ").append(this.destinations()).append(",");
        }
        if (this.rawMessage() != null) {
            sb.append("RawMessage: ").append(this.rawMessage()).append(",");
        }
        if (this.fromArn() != null) {
            sb.append("FromArn: ").append(this.fromArn()).append(",");
        }
        if (this.sourceArn() != null) {
            sb.append("SourceArn: ").append(this.sourceArn()).append(",");
        }
        if (this.returnPathArn() != null) {
            sb.append("ReturnPathArn: ").append(this.returnPathArn()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.configurationSetName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Destinations": {
                return Optional.of(clazz.cast(this.destinations()));
            }
            case "RawMessage": {
                return Optional.of(clazz.cast(this.rawMessage()));
            }
            case "FromArn": {
                return Optional.of(clazz.cast(this.fromArn()));
            }
            case "SourceArn": {
                return Optional.of(clazz.cast(this.sourceArn()));
            }
            case "ReturnPathArn": {
                return Optional.of(clazz.cast(this.returnPathArn()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "ConfigurationSetName": {
                return Optional.of(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private List<String> destinations;
        private RawMessage rawMessage;
        private String fromArn;
        private String sourceArn;
        private String returnPathArn;
        private List<MessageTag> tags;
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendRawEmailRequest model) {
            this.source(model.source);
            this.destinations(model.destinations);
            this.rawMessage(model.rawMessage);
            this.fromArn(model.fromArn);
            this.sourceArn(model.sourceArn);
            this.returnPathArn(model.returnPathArn);
            this.tags(model.tags);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Collection<String> getDestinations() {
            return this.destinations;
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = AddressListCopier.copy(destinations);
        }

        public final RawMessage.Builder getRawMessage() {
            return this.rawMessage != null ? this.rawMessage.toBuilder() : null;
        }

        @Override
        public final Builder rawMessage(RawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public final void setRawMessage(RawMessage.BuilderImpl rawMessage) {
            this.rawMessage = rawMessage != null ? rawMessage.build() : null;
        }

        public final String getFromArn() {
            return this.fromArn;
        }

        @Override
        public final Builder fromArn(String fromArn) {
            this.fromArn = fromArn;
            return this;
        }

        public final void setFromArn(String fromArn) {
            this.fromArn = fromArn;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        public final Collection<MessageTag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(MessageTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(MessageTag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<MessageTag.BuilderImpl> tags) {
            this.tags = MessageTagListCopier.copyFromBuilder(tags);
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public SendRawEmailRequest build() {
            return new SendRawEmailRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendRawEmailRequest> {
        public Builder source(String var1);

        public Builder destinations(Collection<String> var1);

        public Builder destinations(String ... var1);

        public Builder rawMessage(RawMessage var1);

        public Builder fromArn(String var1);

        public Builder sourceArn(String var1);

        public Builder returnPathArn(String var1);

        public Builder tags(Collection<MessageTag> var1);

        public Builder tags(MessageTag ... var1);

        public Builder configurationSetName(String var1);
    }
}

