/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array that contains one or more Destinations, as well as the tags and replacement data associated with each of
 * those Destinations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BulkEmailDestination implements ToCopyableBuilder<BulkEmailDestination.Builder, BulkEmailDestination> {
    private final Destination destination;

    private final List<MessageTag> replacementTags;

    private final String replacementTemplateData;

    private BulkEmailDestination(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementTemplateData = builder.replacementTemplateData;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public Destination destination() {
        return destination;
    }

    /**
     * <p>
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using
     * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that you
     * can publish email sending events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tags, in the form of name/value pairs, to apply to an email that you send using
     *         <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so
     *         that you can publish email sending events.
     */
    public List<MessageTag> replacementTags() {
        return replacementTags;
    }

    /**
     * <p>
     * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of
     * key-value pairs in which the keys correspond to replacement tags in the email template.
     * </p>
     * 
     * @return A list of replacement values to apply to the template. This parameter is a JSON object, typically
     *         consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
     */
    public String replacementTemplateData() {
        return replacementTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(replacementTags());
        hashCode = 31 * hashCode + Objects.hashCode(replacementTemplateData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestination)) {
            return false;
        }
        BulkEmailDestination other = (BulkEmailDestination) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(replacementTags(), other.replacementTags())
                && Objects.equals(replacementTemplateData(), other.replacementTemplateData());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        if (replacementTags() != null) {
            sb.append("ReplacementTags: ").append(replacementTags()).append(",");
        }
        if (replacementTemplateData() != null) {
            sb.append("ReplacementTemplateData: ").append(replacementTemplateData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.of(clazz.cast(destination()));
        case "ReplacementTags":
            return Optional.of(clazz.cast(replacementTags()));
        case "ReplacementTemplateData":
            return Optional.of(clazz.cast(replacementTemplateData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, BulkEmailDestination> {
        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link Destination.Builder} avoiding the need to create
         * one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().apply(destination).build());
        }

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using
         * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using
         *        <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define,
         *        so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(Collection<MessageTag> replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using
         * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using
         *        <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define,
         *        so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(MessageTag... replacementTags);

        /**
         * <p>
         * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting
         * of key-value pairs in which the keys correspond to replacement tags in the email template.
         * </p>
         * 
         * @param replacementTemplateData
         *        A list of replacement values to apply to the template. This parameter is a JSON object, typically
         *        consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTemplateData(String replacementTemplateData);
    }

    static final class BuilderImpl implements Builder {
        private Destination destination;

        private List<MessageTag> replacementTags;

        private String replacementTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailDestination model) {
            destination(model.destination);
            replacementTags(model.replacementTags);
            replacementTemplateData(model.replacementTemplateData);
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<MessageTag.Builder> getReplacementTags() {
            return replacementTags != null ? replacementTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(MessageTag... replacementTags) {
            replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        public final String getReplacementTemplateData() {
            return replacementTemplateData;
        }

        @Override
        public final Builder replacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
            return this;
        }

        public final void setReplacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
        }

        @Override
        public BulkEmailDestination build() {
            return new BulkEmailDestination(this);
        }
    }
}
