/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a new IP address filter. You use IP address filters when you receive email with Amazon
 * SES. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReceiptFilterRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateReceiptFilterRequest.Builder, CreateReceiptFilterRequest> {
    private final ReceiptFilter filter;

    private CreateReceiptFilterRequest(BuilderImpl builder) {
        this.filter = builder.filter;
    }

    /**
     * <p>
     * A data structure that describes the IP address filter to create, which consists of a name, an IP address range,
     * and whether to allow or block mail from it.
     * </p>
     * 
     * @return A data structure that describes the IP address filter to create, which consists of a name, an IP address
     *         range, and whether to allow or block mail from it.
     */
    public ReceiptFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptFilterRequest)) {
            return false;
        }
        CreateReceiptFilterRequest other = (CreateReceiptFilterRequest) obj;
        return Objects.equals(filter(), other.filter());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.of(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateReceiptFilterRequest> {
        /**
         * <p>
         * A data structure that describes the IP address filter to create, which consists of a name, an IP address
         * range, and whether to allow or block mail from it.
         * </p>
         * 
         * @param filter
         *        A data structure that describes the IP address filter to create, which consists of a name, an IP
         *        address range, and whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ReceiptFilter filter);

        /**
         * <p>
         * A data structure that describes the IP address filter to create, which consists of a name, an IP address
         * range, and whether to allow or block mail from it.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptFilter.Builder} avoiding the need to
         * create one manually via {@link ReceiptFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(ReceiptFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ReceiptFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ReceiptFilter)
         */
        default Builder filter(Consumer<ReceiptFilter.Builder> filter) {
            return filter(ReceiptFilter.builder().apply(filter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReceiptFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptFilterRequest model) {
            filter(model.filter);
        }

        public final ReceiptFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(ReceiptFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(ReceiptFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public CreateReceiptFilterRequest build() {
            return new CreateReceiptFilterRequest(this);
        }
    }
}
