/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete a configuration set event destination. Configuration set event destinations are
 * associated with configuration sets, which enable you to publish email sending events. For information about using
 * configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteConfigurationSetEventDestinationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteConfigurationSetEventDestinationRequest.Builder, DeleteConfigurationSetEventDestinationRequest> {
    private final String configurationSetName;

    private final String eventDestinationName;

    private DeleteConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
    }

    /**
     * <p>
     * The name of the configuration set from which to delete the event destination.
     * </p>
     * 
     * @return The name of the configuration set from which to delete the event destination.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The name of the event destination to delete.
     * </p>
     * 
     * @return The name of the event destination to delete.
     */
    public String eventDestinationName() {
        return eventDestinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestinationName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigurationSetEventDestinationRequest)) {
            return false;
        }
        DeleteConfigurationSetEventDestinationRequest other = (DeleteConfigurationSetEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestinationName(), other.eventDestinationName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(configurationSetName()).append(",");
        }
        if (eventDestinationName() != null) {
            sb.append("EventDestinationName: ").append(eventDestinationName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.of(clazz.cast(configurationSetName()));
        case "EventDestinationName":
            return Optional.of(clazz.cast(eventDestinationName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteConfigurationSetEventDestinationRequest> {
        /**
         * <p>
         * The name of the configuration set from which to delete the event destination.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set from which to delete the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The name of the event destination to delete.
         * </p>
         * 
         * @param eventDestinationName
         *        The name of the event destination to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinationName(String eventDestinationName);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private String eventDestinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigurationSetEventDestinationRequest model) {
            configurationSetName(model.configurationSetName);
            eventDestinationName(model.eventDestinationName);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final String getEventDestinationName() {
            return eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        @Override
        public DeleteConfigurationSetEventDestinationRequest build() {
            return new DeleteConfigurationSetEventDestinationRequest(this);
        }
    }
}
