/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the details of a receipt rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReceiptRuleResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeReceiptRuleResponse.Builder, DescribeReceiptRuleResponse> {
    private final ReceiptRule rule;

    private DescribeReceiptRuleResponse(BuilderImpl builder) {
        this.rule = builder.rule;
    }

    /**
     * <p>
     * A data structure that contains the specified receipt rule's name, actions, recipients, domains, enabled status,
     * scan status, and Transport Layer Security (TLS) policy.
     * </p>
     * 
     * @return A data structure that contains the specified receipt rule's name, actions, recipients, domains, enabled
     *         status, scan status, and Transport Layer Security (TLS) policy.
     */
    public ReceiptRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleResponse)) {
            return false;
        }
        DescribeReceiptRuleResponse other = (DescribeReceiptRuleResponse) obj;
        return Objects.equals(rule(), other.rule());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (rule() != null) {
            sb.append("Rule: ").append(rule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rule":
            return Optional.of(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReceiptRuleResponse> {
        /**
         * <p>
         * A data structure that contains the specified receipt rule's name, actions, recipients, domains, enabled
         * status, scan status, and Transport Layer Security (TLS) policy.
         * </p>
         * 
         * @param rule
         *        A data structure that contains the specified receipt rule's name, actions, recipients, domains,
         *        enabled status, scan status, and Transport Layer Security (TLS) policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ReceiptRule rule);

        /**
         * <p>
         * A data structure that contains the specified receipt rule's name, actions, recipients, domains, enabled
         * status, scan status, and Transport Layer Security (TLS) policy.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptRule.Builder} avoiding the need to create
         * one manually via {@link ReceiptRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptRule.Builder#build()} is called immediately and its result
         * is passed to {@link #rule(ReceiptRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link ReceiptRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(ReceiptRule)
         */
        default Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return rule(ReceiptRule.builder().apply(rule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleResponse model) {
            rule(model.rule);
        }

        public final ReceiptRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public DescribeReceiptRuleResponse build() {
            return new DescribeReceiptRuleResponse(this);
        }
    }
}
