/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the details of the specified receipt rule set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReceiptRuleSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeReceiptRuleSetResponse.Builder, DescribeReceiptRuleSetResponse> {
    private final ReceiptRuleSetMetadata metadata;

    private final List<ReceiptRule> rules;

    private DescribeReceiptRuleSetResponse(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule set
     * was created.
     * </p>
     * 
     * @return The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the
     *         rule set was created.
     */
    public ReceiptRuleSetMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * A list of the receipt rules that belong to the specified receipt rule set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the receipt rules that belong to the specified receipt rule set.
     */
    public List<ReceiptRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleSetResponse)) {
            return false;
        }
        DescribeReceiptRuleSetResponse other = (DescribeReceiptRuleSetResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(rules(), other.rules());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.of(clazz.cast(metadata()));
        case "Rules":
            return Optional.of(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
        /**
         * <p>
         * The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule
         * set was created.
         * </p>
         * 
         * @param metadata
         *        The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when
         *        the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ReceiptRuleSetMetadata metadata);

        /**
         * <p>
         * The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule
         * set was created.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptRuleSetMetadata.Builder} avoiding the
         * need to create one manually via {@link ReceiptRuleSetMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptRuleSetMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #metadata(ReceiptRuleSetMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ReceiptRuleSetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ReceiptRuleSetMetadata)
         */
        default Builder metadata(Consumer<ReceiptRuleSetMetadata.Builder> metadata) {
            return metadata(ReceiptRuleSetMetadata.builder().apply(metadata).build());
        }

        /**
         * <p>
         * A list of the receipt rules that belong to the specified receipt rule set.
         * </p>
         * 
         * @param rules
         *        A list of the receipt rules that belong to the specified receipt rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ReceiptRule> rules);

        /**
         * <p>
         * A list of the receipt rules that belong to the specified receipt rule set.
         * </p>
         * 
         * @param rules
         *        A list of the receipt rules that belong to the specified receipt rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ReceiptRule... rules);
    }

    static final class BuilderImpl implements Builder {
        private ReceiptRuleSetMetadata metadata;

        private List<ReceiptRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleSetResponse model) {
            metadata(model.metadata);
            rules(model.rules);
        }

        public final ReceiptRuleSetMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ReceiptRuleSetMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Collection<ReceiptRule.Builder> getRules() {
            return rules != null ? rules.stream().map(ReceiptRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReceiptRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ReceiptRule.BuilderImpl> rules) {
            this.rules = ReceiptRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public DescribeReceiptRuleSetResponse build() {
            return new DescribeReceiptRuleSetResponse(this);
        }
    }
}
