/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the notification attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityNotificationAttributesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIdentityNotificationAttributesResponse.Builder, GetIdentityNotificationAttributesResponse> {
    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        this.notificationAttributes = builder.notificationAttributes;
    }

    /**
     * <p>
     * A map of Identity to IdentityNotificationAttributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of Identity to IdentityNotificationAttributes.
     */
    public Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return notificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse) obj;
        return Objects.equals(notificationAttributes(), other.notificationAttributes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (notificationAttributes() != null) {
            sb.append("NotificationAttributes: ").append(notificationAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationAttributes":
            return Optional.of(clazz.cast(notificationAttributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        /**
         * <p>
         * A map of Identity to IdentityNotificationAttributes.
         * </p>
         * 
         * @param notificationAttributes
         *        A map of Identity to IdentityNotificationAttributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            notificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes.Builder> getNotificationAttributes() {
            return notificationAttributes != null ? CollectionUtils.mapValues(notificationAttributes,
                    IdentityNotificationAttributes::toBuilder) : null;
        }

        @Override
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes.BuilderImpl> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copyFromBuilder(notificationAttributes);
        }

        @Override
        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }
    }
}
