/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to list the configuration sets associated with your AWS account. Configuration sets enable you
 * to publish email sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListConfigurationSetsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListConfigurationSetsRequest.Builder, ListConfigurationSetsRequest> {
    private final String nextToken;

    private final Integer maxItems;

    private ListConfigurationSetsRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of the
     * configuration set in the configuration set list.
     * </p>
     * 
     * @return A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of
     *         the configuration set in the configuration set list.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of configuration sets to return.
     * </p>
     * 
     * @return The number of configuration sets to return.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsRequest)) {
            return false;
        }
        ListConfigurationSetsRequest other = (ListConfigurationSetsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListConfigurationSetsRequest> {
        /**
         * <p>
         * A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position of the
         * configuration set in the configuration set list.
         * </p>
         * 
         * @param nextToken
         *        A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position
         *        of the configuration set in the configuration set list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of configuration sets to return.
         * </p>
         * 
         * @param maxItems
         *        The number of configuration sets to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);
    }

    static final class BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsRequest model) {
            nextToken(model.nextToken);
            maxItems(model.maxItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListConfigurationSetsRequest build() {
            return new ListConfigurationSetsRequest(this);
        }
    }
}
