/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return a list of sending authorization policies that are attached to an identity. Sending
 * authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For
 * information, see the <a href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon
 * SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListIdentityPoliciesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListIdentityPoliciesRequest.Builder, ListIdentityPoliciesRequest> {
    private final String identity;

    private ListIdentityPoliciesRequest(BuilderImpl builder) {
        this.identity = builder.identity;
    }

    /**
     * <p>
     * The identity that is associated with the policy for which the policies will be listed. You can specify an
     * identity by using its name or by using its Amazon Resource Name (ARN). Examples: <code>user@example.com</code>,
     * <code>example.com</code>, <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     * </p>
     * <p>
     * To successfully call this API, you must own the identity.
     * </p>
     * 
     * @return The identity that is associated with the policy for which the policies will be listed. You can specify an
     *         identity by using its name or by using its Amazon Resource Name (ARN). Examples:
     *         <code>user@example.com</code>, <code>example.com</code>,
     *         <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
     *         <p>
     *         To successfully call this API, you must own the identity.
     */
    public String identity() {
        return identity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoliciesRequest)) {
            return false;
        }
        ListIdentityPoliciesRequest other = (ListIdentityPoliciesRequest) obj;
        return Objects.equals(identity(), other.identity());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.of(clazz.cast(identity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListIdentityPoliciesRequest> {
        /**
         * <p>
         * The identity that is associated with the policy for which the policies will be listed. You can specify an
         * identity by using its name or by using its Amazon Resource Name (ARN). Examples:
         * <code>user@example.com</code>, <code>example.com</code>,
         * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * </p>
         * <p>
         * To successfully call this API, you must own the identity.
         * </p>
         * 
         * @param identity
         *        The identity that is associated with the policy for which the policies will be listed. You can specify
         *        an identity by using its name or by using its Amazon Resource Name (ARN). Examples:
         *        <code>user@example.com</code>, <code>example.com</code>,
         *        <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.</p>
         *        <p>
         *        To successfully call this API, you must own the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);
    }

    static final class BuilderImpl implements Builder {
        private String identity;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoliciesRequest model) {
            identity(model.identity);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public ListIdentityPoliciesRequest build() {
            return new ListIdentityPoliciesRequest(this);
        }
    }
}
