/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or
 * range of IP addresses.
 * </p>
 * <p>
 * For information about setting up IP address filters, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiptIpFilter implements ToCopyableBuilder<ReceiptIpFilter.Builder, ReceiptIpFilter> {
    private final String policy;

    private final String cidr;

    private ReceiptIpFilter(BuilderImpl builder) {
        this.policy = builder.policy;
        this.cidr = builder.cidr;
    }

    /**
     * <p>
     * Indicates whether to block or allow incoming mail from the specified IP addresses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policy} will
     * return {@link ReceiptFilterPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyString}.
     * </p>
     * 
     * @return Indicates whether to block or allow incoming mail from the specified IP addresses.
     * @see ReceiptFilterPolicy
     */
    public ReceiptFilterPolicy policy() {
        return ReceiptFilterPolicy.fromValue(policy);
    }

    /**
     * <p>
     * Indicates whether to block or allow incoming mail from the specified IP addresses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policy} will
     * return {@link ReceiptFilterPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyString}.
     * </p>
     * 
     * @return Indicates whether to block or allow incoming mail from the specified IP addresses.
     * @see ReceiptFilterPolicy
     */
    public String policyString() {
        return policy;
    }

    /**
     * <p>
     * A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
     * Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range of
     * IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
     * href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
     * </p>
     * 
     * @return A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
     *         Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a
     *         range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
     *         href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
     */
    public String cidr() {
        return cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyString());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptIpFilter)) {
            return false;
        }
        ReceiptIpFilter other = (ReceiptIpFilter) obj;
        return Objects.equals(policyString(), other.policyString()) && Objects.equals(cidr(), other.cidr());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyString() != null) {
            sb.append("Policy: ").append(policyString()).append(",");
        }
        if (cidr() != null) {
            sb.append("Cidr: ").append(cidr()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.of(clazz.cast(policyString()));
        case "Cidr":
            return Optional.of(clazz.cast(cidr()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiptIpFilter> {
        /**
         * <p>
         * Indicates whether to block or allow incoming mail from the specified IP addresses.
         * </p>
         * 
         * @param policy
         *        Indicates whether to block or allow incoming mail from the specified IP addresses.
         * @see ReceiptFilterPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceiptFilterPolicy
         */
        Builder policy(String policy);

        /**
         * <p>
         * Indicates whether to block or allow incoming mail from the specified IP addresses.
         * </p>
         * 
         * @param policy
         *        Indicates whether to block or allow incoming mail from the specified IP addresses.
         * @see ReceiptFilterPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceiptFilterPolicy
         */
        Builder policy(ReceiptFilterPolicy policy);

        /**
         * <p>
         * A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
         * Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of a range
         * of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
         * href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
         * </p>
         * 
         * @param cidr
         *        A single IP address or a range of IP addresses that you want to block or allow, specified in Classless
         *        Inter-Domain Routing (CIDR) notation. An example of a single email address is 10.0.0.1. An example of
         *        a range of IP addresses is 10.0.0.1/24. For more information about CIDR notation, see <a
         *        href="https://tools.ietf.org/html/rfc2317">RFC 2317</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);
    }

    static final class BuilderImpl implements Builder {
        private String policy;

        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptIpFilter model) {
            policy(model.policy);
            cidr(model.cidr);
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder policy(ReceiptFilterPolicy policy) {
            this.policy(policy.toString());
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public ReceiptIpFilter build() {
            return new ReceiptIpFilter(this);
        }
    }
}
