/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt rule sets to
 * receive email with Amazon SES. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetReceiptRulePositionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetReceiptRulePositionRequest.Builder, SetReceiptRulePositionRequest> {
    private final String ruleSetName;

    private final String ruleName;

    private final String after;

    private SetReceiptRulePositionRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
        this.after = builder.after;
    }

    /**
     * <p>
     * The name of the receipt rule set that contains the receipt rule to reposition.
     * </p>
     * 
     * @return The name of the receipt rule set that contains the receipt rule to reposition.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of the receipt rule to reposition.
     * </p>
     * 
     * @return The name of the receipt rule to reposition.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The name of the receipt rule after which to place the specified receipt rule.
     * </p>
     * 
     * @return The name of the receipt rule after which to place the specified receipt rule.
     */
    public String after() {
        return after;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(after());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetReceiptRulePositionRequest)) {
            return false;
        }
        SetReceiptRulePositionRequest other = (SetReceiptRulePositionRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName()) && Objects.equals(ruleName(), other.ruleName())
                && Objects.equals(after(), other.after());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ruleSetName() != null) {
            sb.append("RuleSetName: ").append(ruleSetName()).append(",");
        }
        if (ruleName() != null) {
            sb.append("RuleName: ").append(ruleName()).append(",");
        }
        if (after() != null) {
            sb.append("After: ").append(after()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.of(clazz.cast(ruleSetName()));
        case "RuleName":
            return Optional.of(clazz.cast(ruleName()));
        case "After":
            return Optional.of(clazz.cast(after()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SetReceiptRulePositionRequest> {
        /**
         * <p>
         * The name of the receipt rule set that contains the receipt rule to reposition.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set that contains the receipt rule to reposition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of the receipt rule to reposition.
         * </p>
         * 
         * @param ruleName
         *        The name of the receipt rule to reposition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The name of the receipt rule after which to place the specified receipt rule.
         * </p>
         * 
         * @param after
         *        The name of the receipt rule after which to place the specified receipt rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(String after);
    }

    static final class BuilderImpl implements Builder {
        private String ruleSetName;

        private String ruleName;

        private String after;

        private BuilderImpl() {
        }

        private BuilderImpl(SetReceiptRulePositionRequest model) {
            ruleSetName(model.ruleSetName);
            ruleName(model.ruleName);
            after(model.after);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getAfter() {
            return after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        @Override
        public SetReceiptRulePositionRequest build() {
            return new SetReceiptRulePositionRequest(this);
        }
    }
}
