/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an email template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TemplateMetadata implements ToCopyableBuilder<TemplateMetadata.Builder, TemplateMetadata> {
    private final String name;

    private final Instant createdTimestamp;

    private TemplateMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time and date the template was created.
     * </p>
     * 
     * @return The time and date the template was created.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateMetadata)) {
            return false;
        }
        TemplateMetadata other = (TemplateMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (createdTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(createdTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "CreatedTimestamp":
            return Optional.of(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TemplateMetadata> {
        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param name
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time and date the template was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time and date the template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateMetadata model) {
            name(model.name);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public TemplateMetadata build() {
            return new TemplateMetadata(this);
        }
    }
}
