/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TestRenderTemplateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<TestRenderTemplateResponse.Builder, TestRenderTemplateResponse> {
    private final String renderedTemplate;

    private TestRenderTemplateResponse(BuilderImpl builder) {
        this.renderedTemplate = builder.renderedTemplate;
    }

    /**
     * <p>
     * The complete MIME message rendered by applying the data in the TemplateData parameter to the template specified
     * in the TemplateName parameter.
     * </p>
     * 
     * @return The complete MIME message rendered by applying the data in the TemplateData parameter to the template
     *         specified in the TemplateName parameter.
     */
    public String renderedTemplate() {
        return renderedTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renderedTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRenderTemplateResponse)) {
            return false;
        }
        TestRenderTemplateResponse other = (TestRenderTemplateResponse) obj;
        return Objects.equals(renderedTemplate(), other.renderedTemplate());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (renderedTemplate() != null) {
            sb.append("RenderedTemplate: ").append(renderedTemplate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RenderedTemplate":
            return Optional.of(clazz.cast(renderedTemplate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TestRenderTemplateResponse> {
        /**
         * <p>
         * The complete MIME message rendered by applying the data in the TemplateData parameter to the template
         * specified in the TemplateName parameter.
         * </p>
         * 
         * @param renderedTemplate
         *        The complete MIME message rendered by applying the data in the TemplateData parameter to the template
         *        specified in the TemplateName parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderedTemplate(String renderedTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String renderedTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRenderTemplateResponse model) {
            renderedTemplate(model.renderedTemplate);
        }

        public final String getRenderedTemplate() {
            return renderedTemplate;
        }

        @Override
        public final Builder renderedTemplate(String renderedTemplate) {
            this.renderedTemplate = renderedTemplate;
            return this;
        }

        public final void setRenderedTemplate(String renderedTemplate) {
            this.renderedTemplate = renderedTemplate;
        }

        @Override
        public TestRenderTemplateResponse build() {
            return new TestRenderTemplateResponse(this);
        }
    }
}
