/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the configuration set you specified already contains a TrackingOptions object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrackingOptionsAlreadyExistsException extends SESException implements
        ToCopyableBuilder<TrackingOptionsAlreadyExistsException.Builder, TrackingOptionsAlreadyExistsException> {
    private final String configurationSetName;

    private TrackingOptionsAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.configurationSetName = builder.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Indicates that a TrackingOptions object already exists in the specified configuration set.
     * </p>
     * 
     * @return Indicates that a TrackingOptions object already exists in the specified configuration set.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    public interface Builder extends CopyableBuilder<Builder, TrackingOptionsAlreadyExistsException> {
        /**
         * <p>
         * Indicates that a TrackingOptions object already exists in the specified configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        Indicates that a TrackingOptions object already exists in the specified configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSetName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingOptionsAlreadyExistsException model) {
            configurationSetName(model.configurationSetName);
            this.message = model.getMessage();
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public TrackingOptionsAlreadyExistsException build() {
            return new TrackingOptionsAlreadyExistsException(this);
        }
    }
}
