/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import static java.util.stream.Collectors.toMap;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class VerificationAttributesCopier {
    static Map<String, IdentityVerificationAttributes> copy(
            Map<String, IdentityVerificationAttributes> verificationAttributesParam) {
        if (verificationAttributesParam == null) {
            return null;
        }
        Map<String, IdentityVerificationAttributes> verificationAttributesParamCopy = verificationAttributesParam.entrySet()
                .stream().collect(toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Collections.unmodifiableMap(verificationAttributesParamCopy);
    }

    static Map<String, IdentityVerificationAttributes> copyFromBuilder(
            Map<String, ? extends IdentityVerificationAttributes.Builder> verificationAttributesParam) {
        if (verificationAttributesParam == null) {
            return null;
        }
        return copy(verificationAttributesParam.entrySet().stream().collect(toMap(Map.Entry::getKey, e -> e.getValue().build())));
    }
}
