/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListIdentityPoliciesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListIdentityPoliciesResponseUnmarshaller implements
        Unmarshaller<ListIdentityPoliciesResponse, StaxUnmarshallerContext> {

    public ListIdentityPoliciesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListIdentityPoliciesResponse.Builder listIdentityPoliciesResponse = ListIdentityPoliciesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<String> policyNames = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listIdentityPoliciesResponse.policyNames(policyNames);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("PolicyNames", targetDepth)) {
                    policyNames = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("PolicyNames/member", targetDepth)) {
                    policyNames.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listIdentityPoliciesResponse.policyNames(policyNames);
                    break;
                }
            }
        }
        return listIdentityPoliciesResponse.build();
    }

    private static final ListIdentityPoliciesResponseUnmarshaller INSTANCE = new ListIdentityPoliciesResponseUnmarshaller();

    public static ListIdentityPoliciesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
